package gov.va.fnod.model;

public class PasswordHasherApp {

	/**
	 * Use:  from a command line, run this class passing only one parameter: the password to hash.
	 * The program will verify the validity of the password, and print the hash of it either way.
	 * @param args
	 */
	public static void main(String[] args) {
		String password = null;
		if (args == null || args.length == 0) {
			System.out.println("Please enter a password to hash!");
		}
		else {
			password = args[0];
		}
		
		// password = "myPassword";
		
		PasswordValidator validator = new PasswordValidator();
		boolean valid = validator.validatePasswordChars(password);
		System.out.println(valid ? "The password IS valid!" : "The password is NOT valid!");
		PasswordHasher hasher = new PasswordHasher();
		String hashedPassword = hasher.hashPassword(password);
		System.out.println("Hashed Password: " + hashedPassword);
	}
	
	
}
