package gov.va.fnod.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class DataHelper {

	/**
	 * get valid password list for testing
	 * 
	 * @return
	 */
	public static List<String> getValidPasswords() {
		ArrayList<String> validPasswords = new ArrayList<String>();
		validPasswords.add("test1Ab@\"\\\'?,./");
		validPasswords.add("test2B~`!@#$%^&*()_-+={}[]|:;<>,.?st");
		validPasswords.add("test1Ab@ \"\\\'?,./");
		return validPasswords;
	}

	/**
	 * get invalid password list for testing t1T@ - too short testT@test -
	 * missing digit 1TEST$%^&( - missing lowercase character 1test$%^&( -
	 * missing uppercase character test123TEST - missing special character
	 * test123TEST@12345678901234567890asdfghjkl2 - contains space
	 * 
	 * @return
	 */
	public static List<String> getInvalidPasswords() {
		ArrayList<String> invalidPasswords = new ArrayList<String>();
		invalidPasswords.add("testT@test");
		invalidPasswords.add("1TEST$%^&(");
		invalidPasswords.add("1test$%^&(");
		invalidPasswords.add("test123TEST");
		invalidPasswords.add("test123TEST@12345678901234567890asdfghjkl2");
		invalidPasswords.add("");
		invalidPasswords.add(null);
		return invalidPasswords;
	}

	/**
	 * get password data for testing
	 * 
	 * @return
	 */
	public static PasswordData getPasswordData() {
		PasswordData passwordData = new PasswordData();
		passwordData
				.setPassword("3043d5f90184fa31d8ebec59b401ae52ef0cbb0a5a7c986cd8b3cc5d918fc3d0f462eb69");
		Calendar today = Calendar.getInstance();
		today.add(Calendar.DATE, -50);
		passwordData.setPasswordChangedDate(today.getTime());
		passwordData.setPasswordMinLength(8);
		passwordData.setPasswordMaxLength(40);
		return passwordData;
	}

	/**
	 * get password for testing
	 * 
	 * @return
	 */
	public static String getPassword() {
		return "!2TESTuser";
	}

	/**
	 * get the password history list for testing if the new password exists in
	 * the password history
	 * 
	 * @return
	 */
	public static List<String> getPasswordHistoryListNotExists() {
		List<String> passwordHistoryList = new ArrayList<String>();
		passwordHistoryList
				.add("27c421a0fef810cd9356143450ae2f45fe08294fb40df400e31abab0e6dc544c8702cf16");
		passwordHistoryList
				.add("ccdcb5056dc653082db19fef1dbb344806693f83a12876347fae2c8329d07eabd955f1ac|dddcb5056dc653082db19fef1dbb344806693f83a12876347fae2c8329d07eabd955f1ac");
		passwordHistoryList
				.add("cab2c16277953436f797f27efdb7286d2e7321deb4a0afbbf8b6d8d8f5fea597fc067dbf|da75ddeceffb7ef334789c37ff5ea194eeb13387f5f57bf521c4d802182789fd11c58c05|6629401d38f842cc900dbbf80d8a4711fe58a9b083ca2d6a68923d7db0c1eb8e7ce5559f|899236790be4ef954c5e1ef385d236d1e32707edbe315bfcdcf182fde52eb7afb2beff36");
		return passwordHistoryList;
	}

	/**
	 * get the password history list for testing if the new password exists in
	 * the password history
	 * 
	 * @return
	 */
	public static List<String> getPasswordHistoryListExists() {
		List<String> passwordHistoryList = new ArrayList<String>();
		passwordHistoryList
				.add("17c421a0fef810cd9356143450ae2f45fe08294fb40df400e31abab0e6dc544c8702cf16");
		passwordHistoryList
				.add("ccdcb5056dc653082db19fef1dbb344806693f83a12876347fae2c8329d07eabd955f1ac|dcdcb5056dc653082db19fef1dbb344806693f83a12876347fae2c8329d07eabd955f1ac");
		passwordHistoryList
				.add("7ab2c16277953436f797f27efdb7286d2e7321deb4a0afbbf8b6d8d8f5fea597fc067dbf|aa85ddeceffb7ef334789c37ff5ea194eeb13387f5f57bf521c4d802182789fd11c58c05|6639401d38f842cc900dbbf80d8a4711fe58a9b083ca2d6a68923d7db0c1eb8e7ce5559f|889236790be4ef954c5e1ef385d236d1e32707edbe315bfcdcf182fde52eb7afb2beff36");
		return passwordHistoryList;
	}
	
	/**
	 * get password parameters for testing
	 * @return
	 */
	public static PasswordParameters getPasswordParams() {
		PasswordParameters passwordParams = new PasswordParameters();
		passwordParams.setPasswordWarningDays(15);
		passwordParams.setNumOfPasswordHistory(10);
		passwordParams.setLoginRetries(3);
		return passwordParams;
	}

	public static List<String> getInvalidUsernames() {
		ArrayList<String> invalidUsernames = new ArrayList<String>();
		invalidUsernames.add("test");
		invalidUsernames.add("test User");
		invalidUsernames.add("test1234#");
		invalidUsernames.add("testuser1234567890123456789012345678901234567890");
		return invalidUsernames;
	}
	
	public static List<String> getValidUsernames() {
		ArrayList<String> validUsernames = new ArrayList<String>();
		validUsernames.add("testuser");
		validUsernames.add("testUser");
		validUsernames.add("testUSER1234");
		return validUsernames;
	}
	
}