package gov.va.fnod.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SampleDataGenerator {

protected Connection connection;
	
	public SampleDataGenerator(String host, String port, String database, String username, String password) {
		try {
			Class.forName("oracle.jdbc.OracleDriver").newInstance();
			String url = "jdbc:oracle:thin:@" + host + ":" + port + "/" + database;
			System.out.println("Connecting to " + url);
			connection = DriverManager.getConnection(url, username, password);
			System.out.println("Connected");
		}
		
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void disconnect() {
		try {
			connection.close();
		}
		
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void loadCaseLink() {
		try {
			String sql = 
				"insert into case_link(case_id, src_table, case_type_id, source_system_id) " +
				"values(?, ?, ?, ?)";
			PreparedStatement ps = connection.prepareStatement(sql);
	
			System.out.println("Loading Case Link Records ...");
			
			for (int i = 2; i <= 2000; i++) {
				ps.setInt(1, i);
				ps.setString(2, "A");
				ps.setInt(3, ((i % 16) / 4) + 1);
				ps.setInt(4, (i % 4) + 1);
				ps.execute();
			}
			
			ps.close();
		}
		
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void loadFNOD() {
		try {
			SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
			Date startDate = dateFormat.parse("2011-07-01");
			long dateTime = startDate.getTime();
			
			String sql = 
				"insert into fnod_record (username, case_id, case_created_dt, regional_office_id, fnod_created_dt, veteran_last_name, veteran_first_name, fnod, benefit_cancelled, monthly_amount, pmc) " +
				"values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			PreparedStatement ps = connection.prepareStatement(sql);
	
			System.out.println("Loading FNOD Records ...");
			
			for (int i = 1; i <= 2000; i++, dateTime = dateTime + (24 * 60 * 60 * 1000 * 120 / 100)) {			
				if (i % 3 == 0) {
					if (i % 10 == 0) {
						for (int j = 0; i <= 300 && j < 10; i++, j++) {
							if (i % 2 == 0) {
								ps.setString(1, "TESTPSA");
							}
							else {
								ps.setString(1, "TESTSUPERVISOR");
							}
							ps.setInt(2, i);
							ps.setDate(3, new java.sql.Date(dateTime));
							ps.setInt(4, (i % 12) + 2);
							ps.setDate(5, new java.sql.Date(dateTime + (45 * 60 * 1000)));
							ps.setString(6, "Last" + i);
							ps.setString(7, "First" + i);
							ps.setString(8, "Y");
							ps.setString(9, "Y");
							ps.setFloat(10, 200.00f + (21.0f * i % 15));
							ps.setString(11, "Y");
							ps.execute();
						}
					}
					else {
						if (i % 2 == 0) {
							ps.setString(1, "TESTUSER");
						}
						else {
							ps.setString(1, "TESTER1");
						}
						ps.setInt(2, i);
						ps.setDate(3, new java.sql.Date(dateTime - (10 * 24 * 60 * 60 * 1000)));
						ps.setInt(4, (i % 12) + 2);
						ps.setDate(5, new java.sql.Date(dateTime));
						ps.setString(6, "Last" + i);
						ps.setString(7, "First" + i);
						ps.setString(8, null);
						ps.setString(9, "Y");
						ps.setFloat(10, 200.00f + (21.0f * i % 15));
						ps.setString(11, "Y");
						ps.execute();
					}
				}
				else {
					if (i % 2 == 0) {
						ps.setString(1, "TESTPSA");
					}
					else {
						ps.setString(1, "TESTSUPERVISOR");
					}
					ps.setInt(2, i);
					ps.setDate(3, new java.sql.Date(dateTime));
					ps.setInt(4, (i % 12) + 2);
					ps.setDate(5, new java.sql.Date(dateTime));
					ps.setString(6, "Last" + i);
					ps.setString(7, "First" + i);
					ps.setString(8, "Y");
					ps.setString(9, "Y");
					ps.setFloat(10, 200.00f + (21.0f * i % 15));
					ps.setString(11, "Y");
					ps.execute();
				}
				
				System.out.println("Loaded " + i);
			}
			
			System.out.println("Finished");
			ps.close();
		}
		
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void main(String[] args) {
		SampleDataGenerator g = new SampleDataGenerator("10.228.1.9", "1526", "dev", "fnod_data", "develop");
		//g.loadCaseLink();
		g.loadFNOD();
	}
}
