package gov.va.fnod.util;

import java.text.SimpleDateFormat;
import java.util.Date;

public class OracleTimestampTimeZoneConverter {
	
	private static final String DATE_PATTERN = "MM/dd/yyyy hh:mm:ss a z";
	private static final SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
	
	public final static String EST = "EST";
	public final static String CST = "CST";
	public final static String MST = "MST";
	public final static String PST = "PST";
	public final static String AKST = "AKST";
	public final static String HAST = "HAST";
	public final static String CET = "CET";
	public final static String IST = "IST";
	public final static String AST = "AST";
	public final static String GST = "GST";
	public final static String PKT = "PKT";
	public final static String BST = "BST";
	public final static String THA = "THA";
	public final static String SST = "SST";
	public final static String JST = "JST";
	public final static String AEST = "AEST";
	public final static String SBT = "SBT";
	public final static String NZST = "NZST";
	public final static String AZOST = "AZOST";
	public final static String FNT = "FNT";
	public final static String FKST = "FKST";
	
	
	
	public static String convertOffsetToTimeZoneName(String dateStr) { 
		if(dateStr != null) { 
			// server is in EST, or EDT, which can be -4 or -5 hrs
			// so we have to check for both. 
			if(dateStr.contains("GMT-0400") || dateStr.contains("GMT-0500")) { 
				dateStr.replace("GMT-0400", EST);
			}else if( dateStr.contains("GMT-0600") ) { 
				dateStr.replace("GMT-0600", CST); 
			}else if( dateStr.contains("GMT-0700") ) {
				dateStr.replace("GMT-0700", MST); 
			}else if( dateStr.contains("GMT-0800") ) {
				dateStr.replace("GMT-0800", PST); 
			}else if( dateStr.contains("GMT-0900") ) {
				dateStr.replace("GMT-0900", AKST); 
			}else if( dateStr.contains("GMT-1000") ) {
				dateStr.replace("GMT-1000", HAST); 
			}
		} else { 
			dateStr = "";
		}
		return dateStr;
	}
	
	
	public static String formatDateWithTimeZone(Date d) {
		if(d != null) { 
			String dateStr = OracleTimestampTimeZoneConverter.convertOffsetToTimeZoneName(format.format(d));
		return dateStr;	
		} else  { 
			return "";
		}
	}

}
