package gov.va.fnod.util;

import gov.va.fnod.model.FNODModelConstants;
import java.sql.Connection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DatabaseUtil {

	/**
	 * Get the container DataSource
	 * 
	 * @return the same DataSource used for the
	 */
	private static DataSource getDataSource() {
		DataSource ds = null;
		try {
			InitialContext initialContext = new InitialContext();
			ds = (DataSource) initialContext.lookup(FNODModelConstants.DEFAULT_JNDI_NAME);
		} catch (NamingException e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
		return ds;
	}

	public static Connection getConnection() {
		try {
			Connection conn = getDataSource().getConnection();
			conn.setAutoCommit(false);
			return conn;
		} catch (Exception e) {
			throw new RuntimeException("Failed to get connection for " + FNODModelConstants.DEFAULT_JNDI_NAME, e);
		}
	}

	public static void releaseConnection(Connection connection) {
		try {
			connection.close();
		} catch (Exception e) {
			throw new RuntimeException("Unable to release connection for " + FNODModelConstants.DEFAULT_JNDI_NAME,
					e);
		}
	}
}
