package gov.va.fnod.service.exception;

import javax.ejb.ApplicationException;

/**
 * This exception class was created so that applications can feel safe throwing this runtime
 * exception to wrap all other unchecked exceptions, ensuring the stateful ejb does not get
 * reclaimed, yet rolling back the transaction as expected.
 *  
 * @author VHAISLHODGEJ
 *
 */
@ApplicationException(rollback = true)
public class StatefulContextRuntimeException extends RuntimeException {

	private static final long serialVersionUID = -8962734879845768010L;

	/**
	 * 
	 */
	public StatefulContextRuntimeException() {
		super();
	}

	/**
	 * @param message
	 * @param cause
	 */
	public StatefulContextRuntimeException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param message
	 */
	public StatefulContextRuntimeException(String message) {
		super(message);
	}

	/**
	 * @param cause
	 */
	public StatefulContextRuntimeException(Throwable cause) {
		super(cause);
	}


	
}
