package gov.va.fnod.service;

import gov.va.fnod.model.PasswordParameters;
import gov.va.fnod.model.fnoddata.AppRole;
import gov.va.fnod.model.fnoddata.AppUser;
import gov.va.fnod.model.fnoddata.SystemParameter;
import gov.va.fnod.security.authorization.UserContext;

import java.security.PrivilegedActionException;
import java.util.List;

public interface UserSession {	
	
	/**
	 * get user information
	 * @param username
	 * @return
	 */
	public AppUser getUserInfo(String username);
	
	/**
	 * update the user
	 * @param user
	 */
	public void updateUser(AppUser user);
	
	/**
	 * get the app roles
	 * @return
	 */
	public List<AppRole> getAppRoles();
	
	/**
	 * get the app users
	 * @return
	 */
	public List<AppUser> getAppUsers();
	
	/**
	 * get app users who have pending or parked items 
	 * 
	 * @return
	 */
	public List<AppUser> getParkingLotAppUsers();
	
	/**
	 * get the app users based on the search criteria
	 * @param appUserSearch
	 * @param appRoleSearch
	 * @param activeUserName
	 * @param isSysAdmin 
	 * @return
	 */
	public List<AppUser> getAppUsers(String appUserSearch, String appRoleSearch, UserContext activeUser, boolean isSysAdmin);
	
	/**
	 * create a user
	 * @return
	 */
	public AppUser createUser();
	
	/**
	 * save user profile
	 * @param selAppUser
	 * @param isAddEditUser
	 * @param isResetPassword
	 * @param activeUser
	 */
	public void saveUserProfile(AppUser activeUser, AppUser user, boolean isAddEditUser, boolean isResetPassword);

	
	/**
	 * get the system parameters
	 * @return
	 */
	public List<SystemParameter> getSystemParameters();
	
	/**
	 * get the password parameters
	 * @return
	 */
	public PasswordParameters getPasswordParameters();
	
	/**
	 * Submit system parameter changes
	 * @param systemParams
	 */
	public void saveSystemParameters(List<SystemParameter> systemParams);
	
	/**
	 * delete user
	 * @param selAppUser
	 * @param activeUser 
	 */
	public void deleteUserProfile(UserContext activeUser, AppUser selAppUser) throws PrivilegedActionException;
	

}
