package gov.va.fnod.service;



import gov.va.fnod.security.UserMaintenceUtility;

import gov.va.fnod.security.authorization.UserContext;

import gov.va.fnod.security.exception.AuthenticationException;

import gov.va.fnod.security.exception.AuthorizationException;

import gov.va.fnod.security.exception.PswdValidationException;



import javax.ejb.Stateless;



@Stateless

public class UserMaintenenceSessionBean implements UserMaintenenceSession {



	private UserMaintenceUtility userMaintenceUtility;



	public UserMaintenenceSessionBean() {

		super();

		userMaintenceUtility = new UserMaintenceUtility();	

	}



	@Override

	public void changePswd(UserContext curUser, String oldPswd, String newPswd)

			throws AuthorizationException, AuthenticationException, PswdValidationException {



		userMaintenceUtility.changePswd(curUser, oldPswd, newPswd);



	}



	@Override

	public void resetPswd(UserContext curUserContext, UserContext userContext,

			String pswd) throws AuthorizationException, PswdValidationException   {

		

		userMaintenceUtility.resetPswd(curUserContext, userContext, pswd);



	}



	@Override

	public void lockAccount(UserContext curUserContext, UserContext userContext)

			throws AuthorizationException {



		userMaintenceUtility.lockAccount(curUserContext, userContext);



	}



	@Override

	public void unLockAccount(UserContext curUserContext,

			UserContext userContext) throws AuthorizationException {



		userMaintenceUtility.unLockAccount(curUserContext, userContext);



	}



	@Override

	public UserContext getUserContext(String username) {



		return userMaintenceUtility.getUserContext(username);



	}



}

