package gov.va.fnod.service;



import gov.va.fnod.model.FNODModelConstants;

import gov.va.fnod.model.UserRole;

import gov.va.fnod.model.fnoddata.AppUser;

import gov.va.fnod.security.LoginStatus;

import gov.va.fnod.security.authentication.UserInitialContext;

import gov.va.fnod.security.authentication.UserPswdChangeContext;

import gov.va.fnod.security.authorization.UserContext;

import gov.va.fnod.security.authorization.UserRoleContext;



import java.util.Set;



import javax.ejb.Stateless;

import javax.persistence.EntityManager;

import javax.persistence.PersistenceContext;

import javax.persistence.TypedQuery;


@Stateless
public class UserContextSessionBean implements UserContextSession {



	@PersistenceContext (unitName = FNODModelConstants.DEFAULT_PERSISTENCE_UNIT)

	private EntityManager em;


	public UserContextSessionBean() {
		super();
	}

	
	@Override

	public UserInitialContext getUserContext(String username) {

		return getAppUser(username.trim().toUpperCase());

	}



	@Override

	public UserRoleContext<UserRole> getUserRoleContext(UserContext context) {				

		

		final AppUser appUser = getAppUser(context);

		

		return new UserRoleContext<UserRole>() {



			@Override

			public String getUserName() {

				return appUser.getUsername();

			}



			@Override

			public long getUserId() {

				return appUser.getUserId();

			}



			@Override

			public Set<UserRole> getRoles() {

				return appUser.getRoles();

			}



			@Override

			public LoginStatus getLoginStatus() {

				return appUser.getLoginStatus();

			}

		};

	}



	@Override

	public UserPswdChangeContext getUserPswdChangeContext(UserContext context) {

		return getAppUser(context);

	}



	@Override

	public void save(UserPswdChangeContext context) {

		

		AppUser saveRec;				

		

		if ( context instanceof AppUser ) {

			saveRec = (AppUser)context;

		} else {

			UserPswdChangeContext cxt = getAppUser(context);

			

			cxt.setExpiryDate(context.getExpiryDate());

			cxt.setLastPswdChangeDate(context.getLastPswdChangeDate());

			cxt.setLoginStatus(context.getLoginStatus());

			cxt.setPswdHash(context.getPswdHash());

			cxt.setPswdHistory(context.getPswdHistory());

			cxt.setTimeLockedDate(context.getTimeLockedDate());



			saveRec = (AppUser)cxt;

		}

				

		em.merge(saveRec);		

	}



	@Override

	public void save(UserInitialContext context) {

		AppUser saveRec;



		UserInitialContext cxt = getAppUser(context);

		cxt.setLoginStatus(context.getLoginStatus());

		cxt.setTimeLockedDate(context.getTimeLockedDate());

		cxt.setLastLoginDate(context.getLastLoginDate());

		saveRec = (AppUser) cxt;



		em.merge(saveRec);

	}

	

	private AppUser getAppUser(UserContext context) {

		AppUser retval;

		

		retval = em.find(AppUser.class, context.getUserId());

		

		if (retval == null) {

			throw new IllegalArgumentException("user context not found");

		}

		

		return retval;

	}



	

	private AppUser getAppUser(String username) {

		TypedQuery<AppUser> qry = em.createNamedQuery(AppUser.GET_APP_USER_BY_USERNAME, AppUser.class);

		qry.setParameter("username", username);
		//qry.get

		

		AppUser appUser;

		try {

			 appUser = qry.getSingleResult();

		} catch ( javax.persistence.NoResultException ex) {

			appUser = null;

		}

		return appUser;		

	}



	@Override

	public UserInitialContext getUserInitialContext(UserContext context) {

		return em.find(AppUser.class, context.getUserId());

	}

	

}

