package gov.va.fnod.service;

import gov.va.fnod.model.UserPrivilege;
import gov.va.fnod.security.AuthorizationUtility;
import gov.va.fnod.security.SecurityContextWrapper;
import gov.va.fnod.security.authorization.SecurityContext;
import gov.va.fnod.security.authorization.UserContext;
import gov.va.fnod.security.exception.AccountLockedException;

import java.util.Arrays;
import java.util.EnumSet;

import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class UserAuthorizationSessionBean implements UserAuthorizationSession {

	@EJB
	UserContextSession userContext;
	
	@EJB
	SystemContextSession systemContext;
	
	private AuthorizationUtility authorizationUtil = new AuthorizationUtility();
	

	@Override
	public boolean isUserAuthorized(UserContext userContext,
			SecurityContext<UserPrivilege> securityContext) throws AccountLockedException {
		boolean retval = authorizationUtil.isUserAuthorized(userContext, securityContext); 
		
		return retval;

	}

	@Override
	public SecurityContext<UserPrivilege> createSystemContext(String name,
			UserPrivilege... privs) {
		
		SecurityContextWrapper<UserPrivilege> context; 
		context = new SecurityContextWrapper<UserPrivilege>();
		context.setContextLabel(name);
		
		context.setRequestPrivileges(EnumSet.copyOf(Arrays.asList(privs)));
		
		return context;
	}


}
