package gov.va.fnod.service;

import gov.va.fnod.security.AuthenticationUtility;
import gov.va.fnod.security.authentication.LoginConstraints;
import gov.va.fnod.security.authentication.UserInitialContext;
import gov.va.fnod.security.authorization.AppPrivilege;
import gov.va.fnod.security.authorization.SecurityContext;
import gov.va.fnod.security.authorization.UserContext;
import gov.va.fnod.security.exception.AuthenticationException;
import gov.va.fnod.security.exception.AuthorizationException;
import gov.va.fnod.security.exception.PswdValidationException;

import java.util.Calendar;
import java.util.Date;

import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class UserAuthenticationSessionBean implements UserAuthenticationSession {

	@EJB
	UserContextSession userContext;
	
	@EJB
	SystemContextSession systemContext;

	
	private AuthenticationUtility authenticationUtil = new AuthenticationUtility();
	
	public UserAuthenticationSessionBean() {
		super();
	}

	@Override
	public UserContext login(String username, String pswd)
			throws AuthenticationException {
		
		return authenticationUtil.login(username.trim().toUpperCase(), pswd);
		
	}

	@Override
	public UserContext login(String username, String oldPswd, String newPswd) throws AuthenticationException, AuthorizationException, PswdValidationException  { 
		
		return authenticationUtil.login(username.trim().toUpperCase(), oldPswd, newPswd);
		
	}

	@Override
	public UserContext connect(String username, String pswd)
			throws AuthenticationException {
		
		throw new UnsupportedOperationException("connect without context not supported");
	
	}

	@Override
	public UserContext connect(String username, String pswd,
			SecurityContext<? extends AppPrivilege<?>> context)
			throws AuthenticationException {
		
		return authenticationUtil.connect(username.trim().toUpperCase(), pswd, context);
		
	}

	@Override
	public UserContext connect(String username, String oldPswd, String newPswd)
			throws AuthenticationException, PswdValidationException {

		throw new UnsupportedOperationException("connect without context not supported");
	}

	@Override
	public UserContext connect(String username, String oldPswd, String newPswd,
			SecurityContext<? extends AppPrivilege<?>> context) throws AuthenticationException, AuthorizationException, PswdValidationException
			 {
		
		return authenticationUtil.connect(username.trim().toUpperCase(), oldPswd, newPswd, context);
	}
	@Override
	public Date getWarningDays(UserContext context) {
		
		Date retval = null;
		
		// Get user login information
		UserInitialContext uic = userContext.getUserInitialContext(context);
		Date expiryDate = uic.getExpiryDate();
		
		// Get the number of days for warning.
		LoginConstraints constraints = systemContext.getLoginConstraints();
		int warningDays = constraints.getPswdExpireWarningDays();
		
		// Compute when to start warning
		Calendar warningDay = Calendar.getInstance();
		warningDay.setTime(expiryDate);
		warningDay.add(Calendar.DATE, -warningDays);
		
		// If current time is after the warning day, return the expiry date
		if ( (new Date()).after(warningDay.getTime()) ) {
			retval = expiryDate;
		}
				
		return retval;
	}

}
