package gov.va.fnod.service;

import gov.va.fnod.model.CaseLinkData;
import gov.va.fnod.model.fnoddata.CaseType;
import gov.va.fnod.model.fnoddata.SourceCaseTypeMap;
import gov.va.fnod.model.fnoddata.SourceSystem;

import java.util.List;

/**
 * Interface used for retrieving lookup values
 */
public interface SourceCaseTypeMapSession {

	/**
	 * get the list of all SourceCaseTypeMap objects
	 * 
	 * @return
	 */
	public List<SourceCaseTypeMap> getSourceCaseTypeMapList();

	/**
	 * get the list of all CaseData objects matching the SourcecaseTypeMap, assigned to the given user
	 * 
	 * @return
	 */
	public List<CaseLinkData> getCaseLinkData(SourceCaseTypeMap sourceCaseTypeMap, String username);
	
	/**
	 * get the list of all CaseData objects matching the SourcecaseTypeMap, assigned to the given user
	 * 
	 * @return
	 */
	public List<CaseLinkData> getCaseLinkData2(SourceCaseTypeMap sourceCaseTypeMap, String username);
	
	/**
	 * get the list of all CaseData objects matching the SourcecaseTypeMap, all users
	 * 
	 * @return
	 */
	public List<CaseLinkData> getCaseLinkDataAllUser(SourceCaseTypeMap sourceCaseTypeMap);

	/**
	 * get the list of all SourcecaseTypeMap objects with the given sourceSystem and caseType
	 * 
	 * @param sourceSystem The source system to match
	 * @param caseTyep The case type to match
	 * @return
	 */
	public SourceCaseTypeMap getSourceCaseTypeMap(SourceSystem sourceSystem, CaseType caseType);
}
