package gov.va.fnod.service;

import gov.va.fnod.model.UserPrivilege;
import gov.va.fnod.model.UserRole;
import gov.va.fnod.security.GenericPswdHash;
import gov.va.fnod.security.SecurityConfigUtility;
import gov.va.fnod.security.authentication.PswdHashInterface;
import gov.va.fnod.security.authentication.PswdValidateComplexityInterface;
import gov.va.fnod.security.service.SystemContextService;
import gov.va.fnod.security.service.UserContextService;

import javax.ejb.EJB;
import javax.ejb.Stateless;

/** 
 * The run method on this class must  must be called by the application to initialize 
 * the configuration of security authentication and authorization sub-systems.
 * 
 * @author Jim Lindelof
 */

@Stateless
public class SecuityInitializerSessionBean implements SecuityInitializerSession {

	@EJB
	private UserContextSession userContextSession;
	
	@EJB
	private SystemContextSession systemContextSession;
	
	public SecuityInitializerSessionBean() {
		super();
	}
	
	@Override
	public void initialize() {
		new SecurityConfigUtility<UserRole, UserPrivilege>() {
			
			@Override
			protected PswdHashInterface getPswdHasher() {
				return new GenericPswdHash();
			}
			
			@Override
			protected PswdValidateComplexityInterface getPswdComplexityValidator() {
				return new PswdComplitityValidator();
			}
			
			@Override
			protected UserContextService<UserRole> getUserContextService() {
				return userContextSession;
			}
			
			@Override
			protected SystemContextService<UserRole, UserPrivilege> getSystemContextService() {
				return systemContextSession;
			}
		};	
	}
	
	

	

	


	
	
}
