package gov.va.fnod.service;



import gov.va.fnod.model.SampleCriteria;

import gov.va.fnod.model.SampleItem;



/**

 * Interface used for generating/getting sample data

 */

public interface SampleSession {



	/**

	 * generate a case sample set

	 * 

	 * @param owner

	 * @param sampleCriteria

	 * @return

	 */

	public int generateCaseSample(String owner, SampleCriteria sampleCriteria);

	

	/**

	 * generate an fnod sample set

	 * 

	 * @param owner

	 * @param sampleCriteria

	 * @return

	 */

	public int generateFnodSample(String owner, SampleCriteria sampleCriteria);

	

	/**

	 * get the next case from the sample set

	 * 

	 * @param owner

	 * @return

	 */

	public SampleItem getNext(String owner, SampleItem lastSampleItem);

	

	/**

	 *  The delete sample functionality is handled in CaseSessionBean since the removal if the item, and

	 *  creating the activity log need to be in the same transaction.  

	 */

	

	/**

	 * clear the existing sample set

	 * 

	 * @param owner

	 * @return

	 */

	public int clearSample(String owner);

	

	/**

	 * add a case to the award case sample set

	 * 

	 * @param caseId

	 * @return

	 */

	public int addAwardCase(long caseId);

	

	/**

	 * get the next case from the award case sample set

	 * 

	 * @param owner

	 * @return

	 */

	public SampleItem getNextAwardCase(String owner, SampleItem lastSampleItem);

	

	/**

	 * 

	 * @param owner

	 * @return

	 */

	public long cancelAwardAudit(SampleItem sampleItem);

}

