package gov.va.fnod.service;

import gov.va.fnod.model.fnoddata.Report;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;

public interface ReportSession {
	
	/**
	 * Creates a List of all the {@link Report} objects.
	 * 
	 * @return A List of {@link Report} objects
	 */
	public List<Report> getReportSelectList();
	
	
	/**
	 * Returns a {@link Report} object by the reportName.
	 * 
	 * @param reportName The reportName String object.
	 * @return The {@link Report} object.
	 */
	public Report getReport(String reportName);
	
	
	/**
	 * Creates two reports from the parameter values. One Jasper report and one report as a CSV file.
	 * 
	 * @param pathToReports The path to all the Jasper Reports templates as a String object.
	 * @param reportName The report name as a String object.
	 * @param parameterValues The parameter values used to build the query statement.
	 * @param reportOut OutputStream of the created Jasper report.
	 * @param csvOut OutputStream of the created CSV report file.
	 */
	public void runReport(String pathToReports, String reportName, HashMap<String,Object> parameterValues, OutputStream reportOut, OutputStream csvOut);


	/**
	 * Returns list of users that either have processed FNOD records in the past, 
	 * or that have the ability to process FNOD records.
	 * 
	 * @return List of user names
	 */
	public List<String> getFnodRecordUsers();
}