package gov.va.fnod.service;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import gov.va.fnod.security.authentication.PswdValidateComplexityInterface;
import gov.va.fnod.security.authentication.UserPswdChangeContext;
import gov.va.fnod.security.exception.PswdComplexityException;

public class PswdComplitityValidator implements PswdValidateComplexityInterface {

	private static Pattern pattern = Pattern
			.compile("((?=.*\\p{Upper})(?=.*\\p{Lower})(?=.*\\p{Digit})(?=.*\\p{Punct})).*");
	
	@Override
	public void validate(UserPswdChangeContext context, String password)
			throws PswdComplexityException {
		
		Matcher matcher = pattern.matcher(password);
		if ( ! matcher.matches() ) {
			throw new PswdComplexityException("Password must contain upper and lower case letter, digits, and special characters");
		}
	}

}
