package gov.va.fnod.service;

import gov.va.fnod.model.FNODModelConstants;
import gov.va.fnod.model.fnoddata.AttachmentType;
import gov.va.fnod.model.fnoddata.CaseLink;
import gov.va.fnod.model.fnoddata.CaseType;
import gov.va.fnod.model.fnoddata.CaseTypeCode;
import gov.va.fnod.model.fnoddata.Region;
import gov.va.fnod.model.fnoddata.RegionalOffice;
import gov.va.fnod.model.fnoddata.SourceSystem;
import gov.va.fnod.model.fnoddata.SourceSystemCode;

import java.util.List;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

/**
 * Session Bean used for retrieving lookup values
 */
@Stateless
public class LookupSessionBean implements LookupSession {

	@PersistenceContext (unitName = FNODModelConstants.DEFAULT_PERSISTENCE_UNIT)
	private EntityManager em;
	
	/**
	 * get the FnodRecord given a Case Id
	 * 
	 * @param caseId
	 * @return
	 */
	@Override
	public CaseLink getCaseLink(long caseId) {
		CaseLink caseLink = null;
		
		try {
			caseLink = em.find(CaseLink.class, caseId);
		}
		
		catch (Exception e) {
			e.printStackTrace();
		}
		
		return caseLink;
	}

	/**
	 * get the list of Regions
	 * 
	 * @return
	 */
	@Override
	public List<Region> getRegions() {
		return em.createNamedQuery(Region.GET_ALL_REGIONS,Region.class).getResultList();
	}
	
	/**
	 * get the list of all Regional Offices
	 * 
	 * @return
	 */
	@Override
	public List<RegionalOffice> getRegionalOffices() {
		return em.createNamedQuery(RegionalOffice.GET_ALL_REGIONAL_OFFICES, RegionalOffice.class).getResultList();
	}

	/**
	 * get the list of Regional Offices given a Region Id
	 * 
	 * @param regionId
	 * @return
	 */
	@Override
	public List<RegionalOffice> getRegionalOffices(long regionId) {
		List<RegionalOffice> regionalOffices = null;
		if (regionId == 0) {
			regionalOffices = em.createNamedQuery(RegionalOffice.GET_ALL_REGIONAL_OFFICES, RegionalOffice.class)
					.getResultList();
		} else {
			regionalOffices = em.createNamedQuery(RegionalOffice.GET_REGIONAL_OFFICE_BY_REGION_ID, RegionalOffice.class)
					.setParameter("regionId", regionId).getResultList();
		}
		return regionalOffices;
	}
	
	@Override
	public RegionalOffice getRegionalOfficeByRegionalOfficeNum(Integer regionalOfficeNum) {
		return (RegionalOffice) em.createNamedQuery(RegionalOffice.GET_REGIONAL_OFFICE_BY_REGION_OFFICE_NUM).setParameter("regionalOfficeNum", regionalOfficeNum).getSingleResult();
	}

	/**
	 * get the list of AttachmentTypes
	 * 
	 * @return
	 */
	@Override
	public List<AttachmentType> getAttachmentTypes() {
		return em.createNamedQuery(AttachmentType.GET_ALL_ATTACHMENTS,AttachmentType.class).getResultList();
	}
	
	@Override
	public CaseType getCaseTypeByCd(String caseTypeCd) {
		return  (CaseType) em.createNamedQuery(CaseType.GET_CASE_TYPE_BY_CASE_TYPE_CODE).setParameter("caseTypeCd", CaseTypeCode.valueOf(caseTypeCd)).getSingleResult();
	}
	
	@Override
	public SourceSystem getSourceSystemByCd(String sourceSystemCd) {
		return (SourceSystem) em.createNamedQuery(SourceSystem.GET_SOURCE_SYSTEM_BY_SOURCE_SYSTEM_CODE).setParameter("sourceSystemCd", SourceSystemCode.valueOf(sourceSystemCd)).getSingleResult();
	}
}
