package gov.va.fnod.service;

import gov.va.fnod.model.fnoddata.AttachmentType;
import gov.va.fnod.model.fnoddata.CaseLink;
import gov.va.fnod.model.fnoddata.CaseType;
import gov.va.fnod.model.fnoddata.Region;
import gov.va.fnod.model.fnoddata.RegionalOffice;
import gov.va.fnod.model.fnoddata.SourceSystem;

import java.util.List;

/**
 * Interface used for retrieving lookup values
 */
public interface LookupSession {

	/**
	 * get the list of Regions
	 * 
	 * @return
	 */
	public List<Region> getRegions();

	/**
	 * get the list of all Regional Offices
	 * 
	 * @return
	 */
	List<RegionalOffice> getRegionalOffices();
	
	/**
	 * get the list of Regional Offices given a Region Id
	 * 
	 * @param regionId
	 * @return
	 */
	public List<RegionalOffice> getRegionalOffices(long regionId);
	
	/**
	 * Get the {@link RegionalOffice} object by the regionalOfficeNum.
	 * 
	 * @param regionalOfficeNum
	 * @return The {@link RegionalOffice} object.
	 */
	public RegionalOffice getRegionalOfficeByRegionalOfficeNum(Integer regionalOfficeNum);

	/**
	 * get the list of AttachmentTypes
	 * 
	 * @return
	 */
	List<AttachmentType> getAttachmentTypes();

	/**
	 * get the CaseLink given a Case Id
	 * 
	 * @param caseId
	 * @return
	 */
	CaseLink getCaseLink(long caseId);
	
	/**
	 * Get the {@link CaseType} object by the caseTypeCd.
	 * 
	 * @param caseTypeCd
	 * @return The {@link CaseType} object
	 */
	public CaseType getCaseTypeByCd(String caseTypeCd);
	
	/**
	 * Get the {@link SourceSystem} object by the sourceSystemCd.
	 * 
	 * @param sourceSystemCd
	 * @return The {@link SourceSystem} object
	 */
	public SourceSystem getSourceSystemByCd(String sourceSystemCd);
}
