package gov.va.fnod.service;



import gov.va.fnod.model.FNODModelConstants;
import gov.va.fnod.util.FNODEJBConstants;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;



@Stateless

@TransactionAttribute(TransactionAttributeType.NOT_SUPPORTED)

public class FnodRecordUserSessionBean implements FnodRecordUserSession {



	@PersistenceContext(unitName = FNODModelConstants.DEFAULT_PERSISTENCE_UNIT)

	private javax.persistence.EntityManager em;



	/**

	 * Returns user names that have completed FNOD case or who currently configured to complete cases.

	 */

	@Override

	public List<String> getFnodRecordCompletedUserNames() {

		//TypedQuery<String> qry;
		Query qry;
		


		qry = em.createQuery("select f.username " + "from FnodRecordUser f where (f.recordCount > 0) and (f.minCreatedDate is not null)");

		List recordUsers = qry.getResultList(); 



		// Get current users that could create FNOD record

		qry = em.createQuery("select u.username " + "from AppUser u join u.appUserRoles ur join ur.appRole r "

			                + "where r.roleCd in ('" + FNODEJBConstants.PSA_ROLE_CD + "','" + FNODEJBConstants.OFF_SUPR_ROLE_CD + "')");		

		List currentUsers = qry.getResultList();



		

		// Merge the two results into a unique sorted list

		SortedSet<String> set = new TreeSet<String>();

		set.addAll(getStringListFromResultList(recordUsers));

		set.addAll(getStringListFromResultList(currentUsers));

		

		return new ArrayList<String>(set);		

	}

	private List<String> getStringListFromResultList(List results) { 
		List<String> retList = new ArrayList<String>();
		
		if(results == null || results.isEmpty()) { 
			return retList;
		} else { 
			for(Object o : results) { 
				retList.add(o.toString());
			}
		}
		return retList;
	}




}

