package gov.va.fnod.service;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import gov.va.fnod.model.FNODModelConstants;
import gov.va.fnod.model.fnoddata.FnodRecord;
@Stateless
public class FnodRecordSessionBean implements FnodRecordSession {

	private static final Logger logr = Logger.getLogger(FnodRecordSession.class.getName());
	
	@PersistenceContext(unitName = FNODModelConstants.DEFAULT_PERSISTENCE_UNIT)
	private EntityManager em;
	
	@Override
	public boolean createFnodRecord(FnodRecord fnodRec) {
		boolean ok = true; 
		try { 
			em.persist(fnodRec);
		}catch(Exception e) { 
			ok = false;
			logr.log(Level.FINE, e.getMessage());
			e.printStackTrace();
		}
		
		return ok;
	}

	@Override
	public FnodRecord getFnodRecordByCaseId(long caseId) {
		FnodRecord fnodRec = null;
		try { 
			fnodRec = em.find(FnodRecord.class, caseId );
		} catch(Exception e) { 
			e.printStackTrace();
		}
		
		return fnodRec;
	}

}
