package gov.va.fnod.service;

import gov.va.fnod.model.SearchCriteria;
import gov.va.fnod.model.fnoddata.ActivityType;
import gov.va.fnod.model.fnoddata.ActivityTypeCode;
import gov.va.fnod.model.fnoddata.CaseLink;

public interface CaseSession {
	
	public CaseLink getCaseLink();
	
	/**
	 * get the CaseLink given a Case Id
	 * 
	 * @param caseId
	 * @return
	 */
	public CaseLink openCaseLinkById(long caseId);

	/**
	 * Saves a new {@link CaseLink} object and returns the created CaseLink ID.
	 * 
	 * @param caseLink The {@link CaseLink} object
	 * @return long The created FNOD Case ID
	 */
	public long addPendingCase(CaseLink caseLink);
	
	public Long searchNextCase(String username, SearchCriteria searchCriteria);
	
	public void saveCaseLink(boolean awardAuditRequired, String username, ActivityTypeCode activityType );
	
	public void cancel();

	public ActivityType getActivityType(ActivityTypeCode activityTypeCode);
	
	public void setCaseLinkNull();
	
	public boolean addFnodRecordForPendingCase(Long caseId, String username) ;
}
