package gov.va.fnod.service;



import gov.va.fnod.model.app.AggregateCountItem;

import gov.va.fnod.util.DatabaseUtil;

import java.sql.Connection;

import java.sql.PreparedStatement;

import java.sql.ResultSet;

import java.sql.SQLException;

import java.sql.Statement;

import java.util.ArrayList;

import java.util.List;

import java.util.logging.Level;

import javax.annotation.Resource;

import javax.ejb.Stateless;

import java.util.logging.Logger;



/**

 * Session Bean implementation class AggregateCounts

 */

@Stateless(name = "AggregateCountsBean")

public class AggregateCountsSessionBean implements AggregateCountsSession {

	private static final Logger logr = Logger.getLogger(AggregateCountsSessionBean.class.getName());



	@Resource(name = "aggregateCountsSummarySQL")

	private String aggregateCountSummarySQL;



	@Resource(name = "aggregateCountsDetailSQL")

	private String aggregateCountDetailSQL;

	
	@Resource(name = "aggregateAwardAuditCountsDetailSQL")

	private String aggregateAwardAuditCountsDetailSQL;

	@Resource(name = "aggregateCountsFlagAppByRegion")

	private String aggregateCountsFlagAppByRegion;



	@Resource(name = "aggregateCountsFlagAppByRegionalOffice")

	private String aggregateCountsFlagAppByRegionalOffice;



	@Resource(name = "aggregateCountsFlagAppByDate")

	private String aggregateCountsFlagAppByDate;


	@Resource(name = "awardAuditPendingCountsSummarySQL")

	private String awardAuditPendingCountsSummarySQL;

	/**

	 * Default constructor.

	 */

	public AggregateCountsSessionBean() {

	}


	
	public List<AggregateCountItem> getAwardAuditPendingSummary() {



		List<AggregateCountItem> summaryItems = new ArrayList<AggregateCountItem>();



		Connection conn = null;

		Statement stmt = null;

		ResultSet rs = null;

		try {

			conn = DatabaseUtil.getConnection();

			stmt = conn.createStatement();

			String sql = awardAuditPendingCountsSummarySQL;

			logr.log(Level.FINEST, "SQL: {0}", sql);

			rs = stmt.executeQuery(sql);



			while (rs.next()) {

				AggregateCountItem item = new AggregateCountItem();

				item.setSourceCaseTypeMapId(rs.getInt("SCTM_ID"));
				item.setTotalCaseCount(rs.getInt("TOTAL"));
				
				summaryItems.add(item);

			}

		} catch (SQLException e) {

			e.printStackTrace();

			throw new RuntimeException(e);

		} finally {

			releaseSQLItems(rs, stmt);

			if (conn != null) {

				DatabaseUtil.releaseConnection(conn);

			}

		}

		return summaryItems;

	}
	

	/**

	 * Retrieves the aggregate count items from the database and maps them to AggregateCountItem objects.

	 * 

	 * @return An AggregateCountItem for each CaseLink category.

	 */

	public List<AggregateCountItem> getAggregateCountSummary() {



		List<AggregateCountItem> summaryItems = new ArrayList<AggregateCountItem>();



		Connection conn = null;

		Statement stmt = null;

		ResultSet rs = null;

		try {

			conn = DatabaseUtil.getConnection();

			stmt = conn.createStatement();

			String sql = aggregateCountSummarySQL;

			logr.log(Level.FINEST, "SQL: {0}", sql);

			rs = stmt.executeQuery(sql);



			while (rs.next()) {

				AggregateCountItem item = new AggregateCountItem();



				item.setSourceCaseTypeMapId(rs.getInt("source_case_type_map_id"));

				item.setPending(rs.getInt("pending"));

				item.setParked(rs.getInt("parked"));

				item.setTotalCaseCount(rs.getInt("total"));



				summaryItems.add(item);

			}

		} catch (SQLException e) {

			e.printStackTrace();

			throw new RuntimeException(e);

		} finally {

			releaseSQLItems(rs, stmt);

			if (conn != null) {

				DatabaseUtil.releaseConnection(conn);

			}

		}

		return summaryItems;

	}



	/**

	 * Retrieves the aggregate count items from the database and maps them to AggregateCountItem objects.

	 * 

	 * @return An AggregateCountItem for each CaseLink category.

	 */

	public List<AggregateCountItem> getAggregateCountDetail(int sourceCaseTypeMapId) {



		List<AggregateCountItem> detailItems = new ArrayList<AggregateCountItem>();



		Connection conn = null;

		PreparedStatement stmt = null;

		ResultSet rs = null;

		try {

			conn = DatabaseUtil.getConnection();

			String sql = aggregateCountDetailSQL;

			stmt = conn.prepareStatement(sql);

			stmt.setInt(1, sourceCaseTypeMapId);

			logr.log(Level.FINEST, "SQL Parameter: {0}", sourceCaseTypeMapId);

			logr.log(Level.FINEST, "SQL: {0}", sql);

			rs = stmt.executeQuery();

			while (rs.next()) {

				AggregateCountItem item = new AggregateCountItem();



				item.setSourceCaseTypeMapId(rs.getInt("source_case_type_map_id"));

				item.setPending(rs.getInt("pending"));

				item.setParked(rs.getInt("parked"));

				item.setTotalCaseCount(rs.getInt("total"));

				item.setLoadDate(rs.getDate("load_dt"));



				detailItems.add(item);

			}

		} catch (SQLException e) {

			e.printStackTrace();

			throw new RuntimeException(e);

		} finally {

			releaseSQLItems(rs, stmt);

			if (conn != null) {

				DatabaseUtil.releaseConnection(conn);

			}

		}

		return detailItems;

	}

	/**

	 * Retrieves the aggregate count items from the database and maps them to AggregateCountItem objects.

	 * 

	 * @return An AggregateCountItem for each CaseLink category.

	 */

	public List<AggregateCountItem> getAggregateCountAwardAuditDetail(int sourceCaseTypeMapId) {



		List<AggregateCountItem> detailItems = new ArrayList<AggregateCountItem>();



		Connection conn = null;

		PreparedStatement stmt = null;

		ResultSet rs = null;

		try {

			conn = DatabaseUtil.getConnection();

			String sql = aggregateAwardAuditCountsDetailSQL;

			stmt = conn.prepareStatement(sql);

			stmt.setInt(1, sourceCaseTypeMapId);

			logr.log(Level.FINEST, "SQL Parameter: {0}", sourceCaseTypeMapId);

			logr.log(Level.FINEST, "SQL: {0}", sql);

			rs = stmt.executeQuery();

			while (rs.next()) {

				AggregateCountItem item = new AggregateCountItem();



				item.setSourceCaseTypeMapId(rs.getInt("source_case_type_map_id"));

				item.setTotalCaseCount(rs.getInt("total"));

				item.setLoadDate(rs.getDate("load_dt"));

				detailItems.add(item);

			}

		} catch (SQLException e) {

			e.printStackTrace();

			throw new RuntimeException(e);

		} finally {

			releaseSQLItems(rs, stmt);

			if (conn != null) {

				DatabaseUtil.releaseConnection(conn);

			}

		}

		return detailItems;

	}

	/**

	 * Retrieves the aggregate count items from the database and maps them to AggregateCountItem objects.

	 * 

	 * @return An AggregateCountItem for each CaseLink category.

	 */

	public List<AggregateCountItem> getAggregateCountFlagAppByRegion() {



		List<AggregateCountItem> detailItems = new ArrayList<AggregateCountItem>();



		Connection conn = null;

		Statement stmt = null;

		ResultSet rs = null;

		try {

			conn = DatabaseUtil.getConnection();

			String sql = aggregateCountsFlagAppByRegion;

			stmt = conn.createStatement();

			rs = stmt.executeQuery(sql);

			logr.log(Level.FINEST, "SQL: {0}", sql);

			while (rs.next()) {

				AggregateCountItem item = new AggregateCountItem();



				item.setSourceCaseTypeMapId(rs.getInt("source_case_type_map_id"));

				item.setPending(rs.getInt("pending"));

				item.setParked(rs.getInt("parked"));

				item.setTotalCaseCount(rs.getInt("total"));

				item.setRegionId(rs.getInt("region_id"));



				detailItems.add(item);

			}

		} catch (SQLException e) {

			e.printStackTrace();

			throw new RuntimeException(e);

		} finally {

			releaseSQLItems(rs, stmt);

			if (conn != null) {

				DatabaseUtil.releaseConnection(conn);

			}

		}

		return detailItems;

	}



	/**

	 * Retrieves the aggregate count items from the database and maps them to AggregateCountItem objects.

	 * 

	 * @return An AggregateCountItem for each CaseLink category.

	 */

	public List<AggregateCountItem> getAggregateCountFlagAppByRegionalOffice(Integer regionId) {



		List<AggregateCountItem> detailItems = new ArrayList<AggregateCountItem>();



		Connection conn = null;

		PreparedStatement stmt = null;

		ResultSet rs = null;

		try {

			conn = DatabaseUtil.getConnection();

			String sql = aggregateCountsFlagAppByRegionalOffice;

			stmt = conn.prepareStatement(sql);

			logr.log(Level.FINEST, "SQL Parameter: {0}", regionId);

			logr.log(Level.FINEST, "SQL: {0}", sql);

			stmt.setInt(1, regionId);

			rs = stmt.executeQuery();

			while (rs.next()) {

				AggregateCountItem item = new AggregateCountItem();



				item.setSourceCaseTypeMapId(rs.getInt("source_case_type_map_id"));

				item.setPending(rs.getInt("pending"));

				item.setParked(rs.getInt("parked"));

				item.setTotalCaseCount(rs.getInt("total"));

				item.setRegionId(rs.getInt("region_id"));

				item.setRegionalOfficeId(rs.getInt("regional_office_id"));

				item.setRegionalOfficeName(rs.getString("regional_office_name"));



				detailItems.add(item);

			}

		} catch (SQLException e) {

			e.printStackTrace();

			throw new RuntimeException(e);

		} finally {

			releaseSQLItems(rs, stmt);

			if (conn != null) {

				DatabaseUtil.releaseConnection(conn);

			}

		}

		return detailItems;

	}



	@Override

	public List<AggregateCountItem> getAggregateCountFlagAppByDate(Integer regionId, Integer regionalOfficeId) {



		List<AggregateCountItem> detailItems = new ArrayList<AggregateCountItem>();



		Connection conn = null;

		PreparedStatement stmt = null;

		ResultSet rs = null;

		try {

			conn = DatabaseUtil.getConnection();

			String sql = aggregateCountsFlagAppByDate;

			stmt = conn.prepareStatement(sql);

			logr.log(Level.FINEST, "SQL Parameter: {0}", regionId);

			logr.log(Level.FINEST, "SQL: {0}", sql);

			stmt.setInt(1, regionId);

			stmt.setInt(2, regionalOfficeId);

			rs = stmt.executeQuery();

			while (rs.next()) {

				AggregateCountItem item = new AggregateCountItem();



				item.setSourceCaseTypeMapId(rs.getInt("source_case_type_map_id"));

				item.setPending(rs.getInt("pending"));

				item.setParked(rs.getInt("parked"));

				item.setTotalCaseCount(rs.getInt("total"));

				item.setRegionId(rs.getInt("region_id"));

				item.setRegionalOfficeId(rs.getInt("regional_office_id"));

				item.setRegionalOfficeName(rs.getString("regional_office_name"));

				item.setLoadDate(rs.getDate("load_dt"));



				detailItems.add(item);

			}

		} catch (SQLException e) {

			e.printStackTrace();

			throw new RuntimeException(e);

		} finally {

			releaseSQLItems(rs, stmt);

			if (conn != null) {

				DatabaseUtil.releaseConnection(conn);

			}

		}

		return detailItems;

	}

	

	private void releaseSQLItems(ResultSet rs, Statement stmt) {

		if (rs != null) {

			try {

				rs.close();

			} catch (SQLException e) {

				logr.log(Level.INFO, "Problem closing result set", e);

			}

		}



		if (stmt != null) {

			try {

				stmt.close();

			} catch (SQLException e) {

				logr.log(Level.INFO, "Problem closing statement", e);

			}

		}

	}



}

