package gov.va.fnod.model.fnoddata;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 * The persistent class for the SYSTEM_PARAMETERS database table.
 * 
 */
@Entity
@Table(name = "SYSTEM_PARAMETERS")
@NamedQueries ( {
	@NamedQuery(name=SystemParameter.GET_ALL_SYSTEM_PARAMETERS, query="select p from SystemParameter p ")
} )
public class SystemParameter implements Serializable {
	private static final long serialVersionUID = 1L;
	
	public static final String GET_ALL_SYSTEM_PARAMETERS = "GET_ALL_SYSTEM_PARAMETERS";

	@Column(name = "SYSTEM_PARAM_ID", unique = true, nullable = false, precision = 9)
	private long systemParamId;

	@Id
	@Column(name = "PARAM_NAME", unique = true, nullable = false, length = 50)
	private String paramName;

	@Column(name = "PARAM_VALUE", nullable = false, length = 50)
	private String paramValue;

	public SystemParameter() {
	}

	public long getSystemParamId() {
		return this.systemParamId;
	}

	public void setSystemParamId(long systemParamId) {
		this.systemParamId = systemParamId;
	}

	public String getParamName() {
		return this.paramName;
	}

	public void setParamName(String paramName) {
		this.paramName = paramName;
	}

	public String getParamValue() {
		return this.paramValue;
	}

	public void setParamValue(String paramValue) {
		this.paramValue = paramValue;
	}

}