package gov.va.fnod.model.fnoddata;

import java.io.Serializable;
import javax.persistence.*;

/**
 * The persistent class for the SOURCE_SYSTEM database table.
 * 
 */
@Entity
@Table(name = "SOURCE_SYSTEM")
@NamedQuery(name=SourceSystem.GET_SOURCE_SYSTEM_BY_SOURCE_SYSTEM_CODE, 
            query="select s from SourceSystem s where s.sourceSystemCd = :sourceSystemCd")
public class SourceSystem implements Serializable {
	private static final long serialVersionUID = 1L;
	
	public static final String GET_SOURCE_SYSTEM_BY_SOURCE_SYSTEM_CODE = "GET_SOURCE_SYSTEM_BY_SOURCE_SYSTEM_CODE";

	@Id
	@Column(name = "SOURCE_SYSTEM_ID", unique = true, nullable = false, precision = 9)
	private long sourceSystemId;

	@Column(nullable = false, length = 30)
	private String description;

	
	@Column(name = "SOURCE_SYSTEM_CD", unique = true, nullable = false, length = 20)
	@Enumerated(EnumType.STRING)
	private SourceSystemCode sourceSystemCd;

	public SourceSystem() {
	}

	public long getSourceSystemId() {
		return this.sourceSystemId;
	}

	public void setSourceSystemId(long sourceSystemId) {
		this.sourceSystemId = sourceSystemId;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public SourceSystemCode getSourceSystemCd() {
		return this.sourceSystemCd;
	}

	public void setSourceSystemCd(SourceSystemCode sourceSystemCd) {
		this.sourceSystemCd = sourceSystemCd;
	}

}