package gov.va.fnod.model.fnoddata;

import java.io.Serializable;
import javax.persistence.*;


/**
 * The persistent class for the SOURCE_CASE_TYPE_MAP database table.
 * 
 */
@Entity
@Table(name="SOURCE_CASE_TYPE_MAP")
@NamedQueries({
	@NamedQuery(name=SourceCaseTypeMap.GET_ALL_SOURCE_CASE_TYPE_MAPS, 
				query="select s from SourceCaseTypeMap s "+
				      "order by s.displayOrder"),
	@NamedQuery(name=SourceCaseTypeMap.GET_SOURCE_CASE_TYPE_MAP_BY_SOURCE_CASE_TYPE, 
				query="select s from SourceCaseTypeMap s " + 
					  "where s.sourceSystem = :sourceSystem " +
					  "and s.caseType = :caseType ")
})

public class SourceCaseTypeMap implements Serializable {
	private static final long serialVersionUID = 1L;
	
	public static final String GET_ALL_SOURCE_CASE_TYPE_MAPS = "GET_ALL_SOURCE_CASE_TYPE_MAPS";
	public static final String GET_SOURCE_CASE_TYPE_MAP_BY_SOURCE_CASE_TYPE = "GET_SOURCE_CASE_TYPE_MAP_BY_SOURCE_CASE_TYPE";

	@Id
	@Column(name="SOURCE_CASE_TYPE_MAP_ID", unique=true, nullable=false)
	private long sourceCaseTypeMapId;

	//uni-directional many-to-one association to CaseType
    @ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="CASE_TYPE_ID", unique=true, nullable=false)
	private CaseType caseType;

	//uni-directional many-to-one association to SourceSystem
    @ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="SOURCE_SYSTEM_ID", unique=true, nullable=false)
	private SourceSystem sourceSystem;
    
    @Column(name = "DESCRIPTION", nullable = false)
    private String description;

    @Column(name="DISPLAY_ORDER", nullable = false)
    private Long displayOrder;
    
    @Column(name="DEF_ELIG_VERIF_YN", nullable = false)
    private String defaultEligibilityVerification;
    
    public SourceCaseTypeMap() {
    }

	public SourceCaseTypeMap(long sourceCaseTypeMapId, CaseType caseType, SourceSystem sourceSystem) {
		this.sourceCaseTypeMapId = sourceCaseTypeMapId;
		this.caseType = caseType;
		this.sourceSystem = sourceSystem;
	}

	public long getSourceCaseTypeMapId() {
		return this.sourceCaseTypeMapId;
	}

	public void setSourceCaseTypeMapId(long sourceCaseTypeMapId) {
		this.sourceCaseTypeMapId = sourceCaseTypeMapId;
	}

	public CaseType getCaseType() {
		return this.caseType;
	}

	public void setCaseType(CaseType caseType) {
		this.caseType = caseType;
	}
	
	public SourceSystem getSourceSystem() {
		return this.sourceSystem;
	}

	public void setSourceSystem(SourceSystem sourceSystem) {
		this.sourceSystem = sourceSystem;
	}
	
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Long getDisplayOrder() {
		return displayOrder;
	}
	
	public void setDisplayOrder(Long displayOrder ){
		this.displayOrder = displayOrder;
	}
	
	public String getDefaultEligibilityVerification() {
		return this.defaultEligibilityVerification;
	}
	
	public void setDefaultEligibilityVerification(String value) {
		this.defaultEligibilityVerification = value;
	}
	
	@Override
	public String toString() {
		return getDescription();
	}
	
	@Override
	public boolean equals(Object object) {
		if (object == null) {
			return false;
		}
		
		SourceCaseTypeMap sourceCaseTypeMap = (SourceCaseTypeMap)object;
		
		return description.equals(sourceCaseTypeMap.description); 
	}
	
	@Override
	public int hashCode() {
		return description.hashCode();
	}
}