package gov.va.fnod.model.fnoddata;

import java.io.Serializable;

import javax.persistence.*;

import net.sf.jasperreports.engine.JasperReport;


/**
 * The persistent class for the REPORT database table.
 * 
 */
@Entity
@Table(name="REPORT")
@NamedQuery(name=Report.GET_ALL_REPORTS, query="select r from Report r ")
public class Report implements Serializable {
	private static final long serialVersionUID = 1L;
	
	public static final String GET_ALL_REPORTS = "GET_ALL_REPORTS";
	
	@Id
	@Column(name="REPORT_ID", unique=true, nullable=false)
	private String reportId;
	
	private String title;
	
	@Column(name="PARAMETER_CODE", unique=true, nullable=false)
	private int parameterCode;

	@Transient
	private JasperReport jasperReport;

	public String getReportId() {
		return this.reportId;
	}

	public String getReportIdRoot() {
		if (reportId.matches(".*-\\d")) {
			return reportId.substring(0, reportId.lastIndexOf("-"));
		}
		
		return this.reportId;
	}

	public void setReportId(String reportId) {
		this.reportId = reportId;
	}
	
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	public int getParameterCode() {
		return parameterCode;
	}

	public void setParameterCode(int parameterCode) {
		this.parameterCode = parameterCode;
	}

	public JasperReport getJasperReport() {
		return jasperReport;
	}

	public void setJasperReport(JasperReport jasperReport) {
		this.jasperReport = jasperReport;
	}
	
	@Override
	public String toString() {
		return title;
	}
	
	@Override
	public boolean equals(Object object) {
		if (object == null) {
			return false;
		}
		
		Report report = (Report)object;
		
		if (reportId == null || report.reportId == null) {
			return false;
		}
		
		return reportId.equals(report.reportId);
	}
	
	@Override
	public int hashCode() {
		if (reportId == null) {
			return -1;
		}
		
		return reportId.hashCode();
	}
}