package gov.va.fnod.model.fnoddata;

import java.io.Serializable;
import javax.persistence.*;
import java.math.BigDecimal;

/**
 * The persistent class for the REGIONAL_OFFICE database table.
 */
@Entity
@Table(name="REGIONAL_OFFICE")
@NamedQueries({
	@NamedQuery(name=RegionalOffice.GET_ALL_REGIONAL_OFFICES, query="select r from RegionalOffice r order by r.regionalOfficeName"),
	@NamedQuery(name=RegionalOffice.GET_REGIONAL_OFFICE_BY_REGION_ID, query="select r from RegionalOffice r where r.region.regionId = :regionId order by r.regionalOfficeName"),
	@NamedQuery(name=RegionalOffice.GET_REGIONAL_OFFICE_BY_REGION_OFFICE_NUM, query="select r from RegionalOffice r where r.regionalOfficeNum = :regionalOfficeNum")
})
public class RegionalOffice implements Serializable, Comparable<RegionalOffice> {
	private static final long serialVersionUID = 1L;
	
	public static final String GET_ALL_REGIONAL_OFFICES = "GET_ALL_REGIONAL_OFFICES";
	public static final String GET_REGIONAL_OFFICE_BY_REGION_ID = "GET_REGIONAL_OFFICE_BY_REGION_ID";
	public static final String GET_REGIONAL_OFFICE_BY_REGION_OFFICE_NUM = "GET_REGIONAL_OFFICE_BY_REGION_OFFICE_NUM";

	@Id
	@Column(name="REGIONAL_OFFICE_ID", unique=true, nullable=false, precision=9)
	private Long regionalOfficeId;

	@Column(name="REGIONAL_OFFICE_NAME", nullable=false, length=50)
	private String regionalOfficeName;

	@Column(name="REGIONAL_OFFICE_NUM", unique=true, nullable=false, precision=3)
	private BigDecimal regionalOfficeNum;

	//bi-directional many-to-one association to Region
    @ManyToOne
	@JoinColumn(name="REGION_ID", nullable=false)
	private Region region;

    public RegionalOffice() {
    }
    
	public long getRegionalOfficeId() {
		return this.regionalOfficeId;
	}

	public void setRegionalOfficeId(long regionalOfficeId) {
		this.regionalOfficeId = regionalOfficeId;
	}
	
	public String getRegionalOfficeName() {
		return this.regionalOfficeName;
	}

	public void setRegionalOfficeName(String regionalOfficeName) {
		this.regionalOfficeName = regionalOfficeName;
	}
	
	public BigDecimal getRegionalOfficeNum() {
		return this.regionalOfficeNum;
	}

	public void setRegionalOfficeNum(BigDecimal regionalOfficeNum) {
		this.regionalOfficeNum = regionalOfficeNum;
	}

	public Region getRegion() {
		return this.region;
	}
	
	public void setRegion(Region region) {
		this.region = region;
	}
	
	@Override
	public String toString() {
		return region.getRegionCd() + " " + regionalOfficeNum + " " + regionalOfficeName;
	}
	
	@Override
	public boolean equals(Object object) {
		if (object == null) {
			return false;
		}
		
		RegionalOffice regionalOffice = (RegionalOffice)object;
		return (regionalOfficeId == regionalOffice.regionalOfficeId);
	}
	
	@Override
	public int hashCode() {
		return (new Long(regionalOfficeId)).hashCode();
	}

	@Override
	public int compareTo(RegionalOffice o) {
		if (o == null) {
			return -1;
		}
		
		if (o.regionalOfficeId == null) {
			return -1;
		}
		else {
			return regionalOfficeId.compareTo(o.regionalOfficeId);
		}
	}
}