package gov.va.fnod.model.fnoddata;

import java.io.Serializable;
import javax.persistence.*;
import java.util.List;


/**
 * The persistent class for the REGION database table.
 * 
 */
@Entity
@Table(name="REGION")
@NamedQuery(name=Region.GET_ALL_REGIONS, query="select r from Region r order by r.description")
public class Region implements Serializable {
	private static final long serialVersionUID = 1L;
	
	public static final String GET_ALL_REGIONS = "GET_ALL_REGIONS";

	@Id
	@Column(name="REGION_ID", unique=true, nullable=false, precision=9)
	private long regionId;

	@Column(nullable=false, length=8)
	private String description;

	@Column(name="REGION_CD", nullable=false, length=1)
	private String regionCd;

	//bi-directional many-to-one association to RegionalOffice
	@OneToMany(mappedBy="region")
	private List<RegionalOffice> regionalOffices;

    public Region() {
    }

	public long getRegionId() {
		return this.regionId;
	}

	public void setRegionId(long regionId) {
		this.regionId = regionId;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getRegionCd() {
		return this.regionCd;
	}
	
	public void setRegionCd(String regionCd) {
		this.regionCd = regionCd;
	}

	public List<RegionalOffice> getRegionalOffices() {
		return this.regionalOffices;
	}

	public void setRegionalOffices(List<RegionalOffice> regionalOffices) {
		this.regionalOffices = regionalOffices;
	}
	
}