package gov.va.fnod.model.fnoddata;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Embeddable;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Embeddable
public class Person implements Serializable, Cloneable {

	private static final long serialVersionUID = -8835666461352639142L;
	
	private String firstName;
	private String lastName;
	private String middleName;
	private String suffixName;
	private String socialSecurityNumber;
	private String decedentId;
	@Temporal(TemporalType.DATE)
	private Date birthDt;
	@Temporal(TemporalType.DATE)
	private Date deathDt;
	@Temporal(TemporalType.DATE)
	private Date recordOfIntermentDt;
	
	public String getFirstName() {
		return firstName;
	}
	
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	
	public String getLastName() {
		return lastName;
	}
	
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getMiddleName() {
		return middleName;
	}
	
	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public String getSuffixName() {
		return suffixName;
	}
	
	public void setSuffixName(String suffixName) {
		this.suffixName = suffixName;
	}

	public String getSocialSecurityNumber() {
		return socialSecurityNumber;
	}
	
	public void setSocialSecurityNumber(String socialSecurityNumber) {
		this.socialSecurityNumber = socialSecurityNumber;
	}

	public String getDecedentId() {
		return decedentId;
	}
	
	public void setDecedentId(String decedentId) {
		this.decedentId = decedentId;
	}

	public Date getBirthDt() {
		return birthDt;
	}
	
	public void setBirthDt(Date birthDt) {
		this.birthDt = birthDt;
	}

	public Date getDeathDt() {
		return deathDt;
	}
	
	public void setDeathDt(Date deathDt) {
		this.deathDt = deathDt;
	}
	
	public Date getRecordOfIntermentDt() {
		return recordOfIntermentDt;
	}
	
	public void setRecordOfIntermentDt(Date recordOfIntermentDt) {
		this.recordOfIntermentDt = recordOfIntermentDt;
	}

	public String getDisplayName() {
		StringBuilder nameBuilder = new StringBuilder();
		
		if (firstName != null) {
			nameBuilder.append(firstName);
		}
		
		if (middleName != null) {
			nameBuilder.append(" " + middleName);
		}
		
		if (lastName != null) {
			nameBuilder.append(" " + lastName);
		}
		
		if (suffixName != null) {
			nameBuilder.append(" " + suffixName);
		}
		
		return nameBuilder.toString();
	}

	public Object clone() {          
		Person copy = null;
		
		try {              
			copy = (Person)super.clone();
			copy.setBirthDt(birthDt == null ? null : new Date(birthDt.getTime()));
			copy.setDeathDt(deathDt == null ? null : new Date(deathDt.getTime()));
			copy.setRecordOfIntermentDt(recordOfIntermentDt == null ? null : new Date(recordOfIntermentDt.getTime()));
		}      
		
		catch(Exception e ) {              
			e.printStackTrace();
		}      
		
		return copy;          
	}
}
