package gov.va.fnod.model.fnoddata;



import java.sql.Timestamp;



import javax.persistence.Cacheable;

import javax.persistence.Column;

import javax.persistence.Entity;

import javax.persistence.Id;

import javax.persistence.Table;



/**

 * The FNOD_RECPRD_USER_MV is a materialized view maintained by the 

 * database to keep summary information about user activity with

 * fnod records.  The primary purpose is to track a distinct list of

 * all users that have ever processed an FNOD case.  Since database is

 * maintaining this list, all caching will be disabled for this entity.

 * 

 * @author Jim Lindelof

 * 

 */

@Entity

@Cacheable(false)

@Table( name = "FNOD_RECORD_USER_MV" )

public class FnodRecordUser {

	

	@Id

	@Column(name="USERNAME", length=32, unique = true, nullable = false)

	private String username;

	

	@Column(name="REC_COUNT", nullable = true)

	private Long recordCount;

	

	@Column(name="MIN_LOCKED_DT", nullable=true)

	private Timestamp minLockedDate;



	@Column(name="MAX_LOCKED_DT", nullable=true)

	private Timestamp maxLockedDate;

		

	@Column(name="MIN_CREATED_DT", nullable=true)

	private Timestamp minCreatedDate;



	@Column(name="MAX_CREATED_DT", nullable=true)

	private Timestamp maxCreatedDate;



	public String getUsername() {

		return username;

	}



	public Long getRecordCount() {

		return recordCount;

	}



	public Timestamp getMinLockedDate() {

		return minLockedDate;

	}



	public Timestamp getMaxLockedDate() {

		return maxLockedDate;

	}



	public Timestamp getMinCreatedDate() {

		return minCreatedDate;

	}



	public Timestamp getMaxCreatedDate() {

		return maxCreatedDate;

	}	

	

	

}

