package gov.va.fnod.model.fnoddata;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;

/**
 * The persistent class for the FNOD_RECORD database table.
 * 
 */
@Entity
@Table(name = "FNOD_RECORD")
public class FnodRecord implements Serializable, Cloneable {
	private static final long serialVersionUID = 1L;

	@Column(name = "BENEFIT_CANCELLED", length = 1)
	private String benefitCancelled;
	
	@Column(name = "BIRLS_ADD", length = 1)
	private String birlsAdd;
	
	@Column(name = "BIRLS_UPDATE", length = 1)
	private String birlsUpdate;
	
	
	@Column(name = "CASE_LOCKED_DT")
	private Timestamp caseLockedDt;
	
	@Lob()
	private String comments;
	
	@Column(name = "DOD_ALREADY_PRESENT", length = 1)
	private String dodAlreadyPresent;

	@Column(name = "ELIGIBILITY_VERIFICATION", length = 1)
	private String eligibilityVerification;

	@Column(name = "FLAG_ISSUED", length = 1)
	private String flagIssued;

	@Column(length = 1)
	private String fnod;

	@Column(name = "FNOD_CREATED_DT", nullable = false)
	private Timestamp fnodCreatedDt;

	@Column(name = "MONTHLY_AMOUNT", precision = 10, scale = 2)
	private BigDecimal monthlyAmount;

	@Column(length = 1)
	private String nmi;

	@Column(length = 1)
	private String pmc;

	@Column(name = "TOO_OLD_TO_CREATE", length = 1)
	private String tooOldToCreate;

	@Column(name = "IRIS", length = 1)
	private String iris;

	@Column(name = "NIS", length = 1)
	private String nis;

	@Column(name = "SENSITIVE", length = 1)
	private String sensitive;

	@Column(name = "FOLDER_ONLY_BENEFIT", length = 1)
	private String folderOnlyBenefit;

	@Column(nullable = false, length = 32)
	private String username;
	
	@Column(name = "VETERAN_CLAIM_NUM", length = 9)
	private String veteranClaimNum;
	
	@Column(name = "MILITARY_SERVICE_NUM", length = 10)
	private String militaryServiceNum;

	// bi-directional one-to-one association to CaseLink
	@Id
	@OneToOne
	@JoinColumn(name = "CASE_ID", nullable = false)
	private CaseLink caseLink;

	// uni-directional many-to-one association to RegionalOffice
	@ManyToOne
	@JoinColumn(name = "REGIONAL_OFFICE_ID")
	private RegionalOffice regionalOffice;

	@AttributeOverrides({
		@AttributeOverride(name="firstName",column=@Column(name="VETERAN_FIRST_NAME")),
		@AttributeOverride(name="lastName",column=@Column(name="VETERAN_LAST_NAME")),
		@AttributeOverride(name="middleName",column=@Column(name="VETERAN_MIDDLE_NAME")),
		@AttributeOverride(name="suffixName",column=@Column(name="VETERAN_SUFFIX_NAME")),
		@AttributeOverride(name="socialSecurityNumber",column=@Column(name="VETERAN_SOCIAL_SECURITY_NUM")),
		@AttributeOverride(name="birthDt",column=@Column(name="VETERAN_BIRTH_DT")),
		@AttributeOverride(name="deathDt",column=@Column(name="VETERAN_DEATH_DT")),
		@AttributeOverride(name="decedentId",column=@Column(name="VETERAN_DECEDENT_ID")),
		@AttributeOverride(name="recordOfIntermentDt",column=@Column(name="VETERAN_RECORD_OF_INTERMENT_DT")),
	}) 
	private Person veteranPerson;
	
	public FnodRecord() {
	}
	
	public String getBenefitCancelled() {
		return this.benefitCancelled;
	}

	public void setBenefitCancelled(String benefitCancelled) {
		this.benefitCancelled = benefitCancelled;
	}
	
	public String getBirlsAdd() {
		return this.birlsAdd;
	}

	public void setBirlsAdd(String birlsAdd) {
		this.birlsAdd = birlsAdd;
	}
	
	public String getBirlsUpdate() {
		return this.birlsUpdate;
	}

	public void setBirlsUpdate(String birlsUpdate) {
		this.birlsUpdate = birlsUpdate;
	}

	public Timestamp getCaseLockedDt() {
		return this.caseLockedDt;
	}

	public void setCaseLockedDt(Timestamp caseLockedDt) {
		this.caseLockedDt = caseLockedDt;
	}

	public String getComments() {
		return this.comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getDodAlreadyPresent() {
		return this.dodAlreadyPresent;
	}

	public void setDodAlreadyPresent(String dodAlreadyPresent) {
		this.dodAlreadyPresent = dodAlreadyPresent;
	}

	public String getEligibilityVerification() {
		return this.eligibilityVerification;
	}

	public void setEligibilityVerification(String eligibilityVerification) {
		this.eligibilityVerification = eligibilityVerification;
	}

	public String getFlagIssued() {
		return this.flagIssued;
	}

	public void setFlagIssued(String flagIssued) {
		this.flagIssued = flagIssued;
	}

	public String getFnod() {
		return this.fnod;
	}

	public void setFnod(String fnod) {
		this.fnod = fnod;
	}

	public Timestamp getFnodCreatedDt() {
		return this.fnodCreatedDt;
	}

	public void setFnodCreatedDt(Timestamp fnodCreatedDt) {
		this.fnodCreatedDt = fnodCreatedDt;
	}

	public BigDecimal getMonthlyAmount() {
		return this.monthlyAmount;
	}

	public void setMonthlyAmount(BigDecimal monthlyAmount) {
		this.monthlyAmount = monthlyAmount;
	}

	public String getNmi() {
		return this.nmi;
	}

	public void setNmi(String nmi) {
		this.nmi = nmi;
	}

	public String getPmc() {
		return this.pmc;
	}

	public void setPmc(String pmc) {
		this.pmc = pmc;
	}

	public String getTooOldToCreate() {
		return this.tooOldToCreate;
	}

	public void setTooOldToCreate(String tooOldToCreate) {
		this.tooOldToCreate = tooOldToCreate;
	}

	public String getIris() {
		return iris;
	}

	public void setIris(String iris) {
		this.iris = iris;
	}

	public String getNis() {
		return nis;
	}

	public void setNis(String nis) {
		this.nis = nis;
	}

	public String getSensitive() {
		return sensitive;
	}

	public void setSensitive(String sensitive) {
		this.sensitive = sensitive;
	}

	public String getFolderOnlyBenefit() {
		return folderOnlyBenefit;
	}

	public void setFolderOnlyBenefit(String folderOnlyBenefit) {
		this.folderOnlyBenefit = folderOnlyBenefit;
	}

	public String getUsername() {
		return this.username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public CaseLink getCaseLink() {
		return this.caseLink;
	}

	public void setCaseLink(CaseLink caseLink) {
		this.caseLink = caseLink;
	}

	public RegionalOffice getRegionalOffice() {
		return this.regionalOffice;
	}

	public void setRegionalOffice(RegionalOffice regionalOffice) {
		this.regionalOffice = regionalOffice;
	}

	public Person getVeteranPerson() {
		if (veteranPerson == null) {
			veteranPerson = new Person();
		}
		return veteranPerson;
	}

	public void setVeteranPerson(Person veteranPerson) {
		this.veteranPerson = veteranPerson;
	}
	
	public String getVeteranClaimNum() {
		return veteranClaimNum;
	}

	public void setVeteranClaimNum(String veteranClaimNum) {
		this.veteranClaimNum = veteranClaimNum;
	}

	public String getMilitaryServiceNum() {
		return militaryServiceNum;
	}

	public void setMilitaryServiceNum(String militaryServiceNum) {
		this.militaryServiceNum = militaryServiceNum;
	}

	public Object clone() {          
		FnodRecord copy = null;
		
		try {              
			copy = (FnodRecord)super.clone();
			
			copy.setCaseLockedDt(caseLockedDt == null ? null : new Timestamp(caseLockedDt.getTime()));
			copy.setFnodCreatedDt(fnodCreatedDt == null ? null : new Timestamp(fnodCreatedDt.getTime()));

			if (veteranPerson != null) {
				copy.setVeteranPerson((Person)veteranPerson.clone());
			}
		}      
		
		catch(Exception e ) {              
			e.printStackTrace();
		}      
		
		return copy;          
	}
	
	public void addUsernameAuditChange(AuditActivity auditActivity, FnodRecord oldFnodRecord) {
		try {              
			List<AuditChange> auditChangeList = auditActivity.getAuditChanges();
			
			if (auditChangeList == null) {
				auditChangeList = new ArrayList<AuditChange>();
				auditActivity.setAuditChanges(auditChangeList);
			}
			
			if (this.username != null && !this.username.equals(oldFnodRecord.username)) {
				auditChangeList.add(new AuditChange(auditActivity, "USERNAME", oldFnodRecord.username, username));
			}
		}      
		
		catch(Exception e ) {              
			e.printStackTrace();
		}      
	}
	
	public boolean awardAuditRequired(FnodRecord oldFnodRecord) {
		boolean awardAuditRequired = false;
		
		try {              
			if (this.monthlyAmount.doubleValue() >= 0.005 && !this.monthlyAmount.equals(oldFnodRecord.monthlyAmount)) {
				awardAuditRequired = true;
			}
		}      
		
		catch(Exception e ) {              
			e.printStackTrace();
		}
		
		return awardAuditRequired;
	}
	
	public void addAwardAuditChange(AuditActivity auditActivity, FnodRecord oldFnodRecord) {
		try {              
			List<AuditChange> auditChangeList = auditActivity.getAuditChanges();
			
			if (auditChangeList == null) {
				auditChangeList = new ArrayList<AuditChange>();
				auditActivity.setAuditChanges(auditChangeList);
			}
			
			if (awardAuditRequired(oldFnodRecord)) {
				auditChangeList.add(new AuditChange(auditActivity, "MONTHLY_AMOUNT", oldFnodRecord.monthlyAmount.toString(), monthlyAmount.toString()));
			}
		}      
		
		catch(Exception e ) {              
			e.printStackTrace();
		}
	}
	
}
