package gov.va.fnod.model.fnoddata;

import java.io.Serializable;
import javax.persistence.*;

/**
 * The persistent class for the CASE_TYPE database table.
 * 
 */
@Entity
@Table(name = "CASE_TYPE")
@NamedQuery(name=CaseType.GET_CASE_TYPE_BY_CASE_TYPE_CODE, query="select c from CaseType c where c.caseTypeCd = :caseTypeCd")
public class CaseType implements Serializable {
	private static final long serialVersionUID = 1L;
	
	public static final String GET_CASE_TYPE_BY_CASE_TYPE_CODE = "GET_CASE_TYPE_BY_CASE_TYPE_CODE";

	@Id	
	@Column(name = "CASE_TYPE_ID", unique = true, nullable = false, precision = 9)
	private long caseTypeId;

	@Column(nullable = false, length = 30)
	private String description;

	@Column(name = "CASE_TYPE_CD", unique = true, nullable = false, length = 20)
	@Enumerated(EnumType.STRING)
	private CaseTypeCode caseTypeCd;
	
	/*@OneToMany
	@JoinColumn(name="CASE_TYPE_ID")
	private CaseLink caseLink;*/

	public CaseType() {
	}

	public long getCaseTypeId() {
		return this.caseTypeId;
	}

	public void setCaseTypeId(long caseTypeId) {
		this.caseTypeId = caseTypeId;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public CaseTypeCode getCaseTypeCd() {
		return this.caseTypeCd;
	}

	public void setCaseTypeCd(CaseTypeCode caseTypeCd) {
		this.caseTypeCd = caseTypeCd;
	}
	
	/*public CaseLink getCaseLink() {
		return caseLink;
	}

	public void setCaseLink(CaseLink caseLink) {
		this.caseLink = caseLink;
	}*/

}