package gov.va.fnod.model.fnoddata;

import gov.va.fnod.model.FNODModelConstants;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import org.eclipse.persistence.annotations.CascadeOnDelete;
import org.eclipse.persistence.platform.database.oracle.annotations.NamedPLSQLStoredFunctionQueries;
import org.eclipse.persistence.platform.database.oracle.annotations.NamedPLSQLStoredFunctionQuery;
import org.eclipse.persistence.platform.database.oracle.annotations.PLSQLParameter;

@Entity
@Table(name = "CASE_LINK")

@NamedPLSQLStoredFunctionQueries({

	@NamedPLSQLStoredFunctionQuery(
			name=CaseLink.GET_NEXT_CASE, 
			functionName=FNODModelConstants.FNOD_DATA_SCHEMA+".FNOD_FIND_CASE_PKG.find_case", 
			returnParameter=@PLSQLParameter(name="nextCaseId", databaseType="INTEGER_TYPE"),
			parameters={
				@PLSQLParameter(name="p_system_id", databaseType="NUMERIC_TYPE"),
				@PLSQLParameter(name="p_case_type_id", databaseType="NUMERIC_TYPE"),
				@PLSQLParameter(name="p_load_from", databaseType="DATE_TYPE"),
				@PLSQLParameter(name="p_load_to", databaseType="DATE_TYPE")
				}),
 
	@NamedPLSQLStoredFunctionQuery(
			name=CaseLink.GET_NEXT_FLAG_APP_CASE, 
			functionName=FNODModelConstants.FNOD_DATA_SCHEMA+".FNOD_FIND_CASE_PKG.find_flag_case", 
			returnParameter=@PLSQLParameter(name="nextCaseId", databaseType="INTEGER_TYPE"),
			parameters={
				@PLSQLParameter(name="p_system_id", databaseType="NUMERIC_TYPE"),
				@PLSQLParameter(name="p_case_type_id", databaseType="NUMERIC_TYPE"),
				@PLSQLParameter(name="p_load_from", databaseType="DATE_TYPE"),
				@PLSQLParameter(name="p_load_to", databaseType="DATE_TYPE"),
				@PLSQLParameter(name="p_region_id", databaseType="NUMERIC_TYPE"),
				@PLSQLParameter(name="p_regional_office_id", databaseType="NUMERIC_TYPE")
				})
})

@NamedQueries({
	@NamedQuery(name=CaseLink.GET_ALL_CASE_LINKS, 
				query="select c from CaseLink c "),
				
	@NamedQuery(name=CaseLink.GET_CASE_LINK_BY_SOURCE_CASE_TYPE_MAP, 
				query="select c from CaseLink c " + 
					  "where c.sourceSystem = :sourceSystem " + 
					  "and c.caseType = :caseType " + 
					  "and c.fnodRecord.username like :username " +
					  "and c.lockedStatus = :lockedStatus " +
					  "order by c.fnodRecord.caseLockedDt desc"),

	@NamedQuery(name=CaseLink.GET_CASE_LINK_BY_USER, 
				query="select c from CaseLink c " + 
					  " where c.fnodRecord.username like :username " +
					  "   and c.lockedStatus = :lockedStatus " +
					  "order by c.fnodRecord.caseLockedDt desc"),

					  
	@NamedQuery(name=CaseLink.GET_CASE_LINK_DATA_BY_USER,
	            query="select new gov.va.fnod.model.CaseLinkData(c.caseId, f.username, ct.description, f.nmi, f.sensitive, f.veteranPerson, c.loadDate, f.caseLockedDt ) " +
	            	  "  from CaseLink c join c.fnodRecord f join c.sourceSystem ss join c.caseType ct " +
	            	  " where f.username like :username " +
	            	  "   and c.lockedStatus = :lockedStatus " +
	            	  " order by f.caseLockedDt desc"),
	            	  
	@NamedQuery(name=CaseLink.GET_CASE_LINK_DATA_BY_SOURCE_CASE_TYPE_MAP, 
				query="select new gov.va.fnod.model.CaseLinkData(c.caseId, f.username, ct.description, f.nmi, f.sensitive, f.veteranPerson, c.loadDate, f.caseLockedDt ) " +
	            	  "  from CaseLink c join c.fnodRecord f join c.sourceSystem ss join c.caseType ct " + 
	  				  " where c.sourceSystem = :sourceSystem " + 
	  			 	  "   and c.caseType = :caseType " + 
	  				  "   and f.username like :username " +
	  				  "   and c.lockedStatus = :lockedStatus " +
	  				  " order by c.fnodRecord.caseLockedDt desc")
	  		            	  	            					
})

@NamedNativeQueries({
	
	@NamedNativeQuery(name=CaseLink.GET_AGGREGATE_COUNT_ALL, 
			query="select SOURCE_SYSTEM_ID, CASE_TYPE_ID, sum(decode(LOCKED_STATUS,'PENDING',cnt,0)), sum(decode(LOCKED_STATUS,'PARKED',cnt,0)), sum(cnt)" +
			"  from (" +
				" select SOURCE_SYSTEM_ID, CASE_TYPE_ID, LOCKED_STATUS, count(*) cnt" +
					" from CASE_LINK" +
					" where LOCKED_STATUS in ('PENDING', 'PARKED')" +
					" group by SOURCE_SYSTEM_ID, CASE_TYPE_ID, LOCKED_STATUS" +
				") group by SOURCE_SYSTEM_ID, CASE_TYPE_ID"),
				
	@NamedNativeQuery(name=CaseLink.GET_AGGREGATE_COUNT_FNOD_CASES, 
			query="select SOURCE_SYSTEM_ID, CASE_TYPE_ID, trunc(LOAD_DT) LOAD_DT, sum(decode(LOCKED_STATUS,'PENDING',cnt,0)), sum(decode(LOCKED_STATUS,'PARKED',cnt,0)), sum(cnt)" +
			" from (" +
				" select cl.SOURCE_SYSTEM_ID, cl.CASE_TYPE_ID, cl.LOCKED_STATUS, trunc(cl.LOAD_DT), count(*) cnt" +
					" from CASE_LINK cl" +
					" where cl.LOCKED_STATUS in ('PENDING','PARKED')" +
					" group by cl.SOURCE_SYSTEM_ID, cl.CASE_TYPE_ID, cl.LOCKED_STATUS, trunc(cl.LOAD_DT)" +
					" ) group by SOURCE_SYSTEM_ID, CASE_TYPE_ID, trunc(LOAD_DT)") ,
					
	@NamedNativeQuery(name=CaseLink.FIND_NEXT_PARKED, 
	                  query="select cl from CaseLink cl where cl.lockedStatus = 'PENDING' LIMIT 1"),
 
})

public class CaseLink implements Serializable {

	private static final long serialVersionUID = 4359343913982140050L;
	
	public static final String GET_ALL_CASE_LINKS = "CaseLink.GET_ALL_CASE_LINKS";
	public static final String GET_CASE_LINK_BY_SOURCE_CASE_TYPE_MAP = "CaseLink.GET_CASE_LINK_BY_SOURCE_CASE_TYPE_MAP";
	public static final String GET_CASE_LINK_BY_USER = "CaseLink.GET_CASE_LINK_BY_USER";
	public static final String GET_AGGREGATE_COUNT_ALL = "CaseLink.GET_AGGREGATE_COUNT_ALL";
	public static final String GET_AGGREGATE_COUNT_FNOD_CASES = "CaseLink.GET_AGGREGATE_COUNT_FNOD_CASES";
	public static final String FIND_NEXT_PARKED = "CaseLink.FIND_NEXT_PARKED";

	public static final String GET_CASE_LINK_DATA_BY_SOURCE_CASE_TYPE_MAP = "CaseLink.GET_CASE_LINK_DATA_BY_SOURCE_CASE_TYPE_MAP";
	public static final String GET_CASE_LINK_DATA_BY_USER = "CaseLink.GET_CASE_LINK_DATA_BY_USER";
	
	public static final String GET_NEXT_CASE = "CaseLink.GET_NEXT_CASE";
	public static final String GET_NEXT_FLAG_APP_CASE = "CaseLink.GET_NEXT_FLAG_APP_CASE";
	
	@Id
	@SequenceGenerator(name = "CASE_LINK_CASE_ID_GENERATOR", sequenceName = "CASE_LINK_SEQ", allocationSize=1)
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "CASE_LINK_CASE_ID_GENERATOR")
	@Column(name = "CASE_ID", unique = true, nullable = false, precision = 9)
	private long caseId;

	@Column(name = "SRC_TABLE", nullable = false, length = 1)
	private String srcTable;

	// bi-directional one-to-many association to CaseAddress
	@OneToMany(mappedBy = "caseLink", cascade = {CascadeType.MERGE, CascadeType.PERSIST}, fetch = FetchType.LAZY)
	private List<CaseAddress> caseAddresses = new ArrayList<CaseAddress>();

	// bi-directional one-to-one association to CaseData
	@OneToOne(mappedBy = "caseLink", cascade = {CascadeType.MERGE, CascadeType.PERSIST}, fetch = FetchType.LAZY)
	private CaseData caseData;
	
	// bi-directional one-to-one association to CaseFlagApp
	@OneToOne(mappedBy = "caseLink", cascade = {CascadeType.MERGE, CascadeType.PERSIST}, fetch = FetchType.LAZY)
	private CaseFlagApp caseFlagApp;

	// bi-directional one-to-one association to CaseInsurance
	@OneToOne(mappedBy = "caseLink", cascade = {CascadeType.MERGE, CascadeType.PERSIST}, fetch = FetchType.LAZY)
	private CaseInsurance caseInsurance;

	// uni-directional many-to-one association to ReportType
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "CASE_TYPE_ID", nullable = false)
	private CaseType caseType;

	// uni-directional many-to-one association to SourceSystem
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "SOURCE_SYSTEM_ID", nullable = false)
	private SourceSystem sourceSystem;

	@Column(name = "LOCKED_STATUS", length = 2)
	@Enumerated(EnumType.STRING)
	private LockedStatus lockedStatus = LockedStatus.PENDING;
	
	// bi-directional one-to-one association to FnodRecord 
	@OneToOne(mappedBy = "caseLink", cascade = {CascadeType.MERGE, CascadeType.PERSIST}, fetch = FetchType.LAZY, optional=true)
	private FnodRecord fnodRecord;
	
	// bi-directional one-to-many association to CaseAttachment
	@CascadeOnDelete
	@OneToMany(mappedBy = "caseLink", cascade = {CascadeType.MERGE, CascadeType.PERSIST}, fetch = FetchType.EAGER, orphanRemoval=true)
	private List<CaseAttachment> caseAttachments = new ArrayList<CaseAttachment>();
	
	// bi-directional one-to-many association to AuditActivity
	@OneToMany(mappedBy = "caseLink", cascade = {CascadeType.MERGE, CascadeType.PERSIST}, fetch = FetchType.LAZY)
	private List<AuditActivity> auditActivity = new ArrayList<AuditActivity>();

	@Column(name = "LOAD_DT", nullable = false)
	private Timestamp loadDate;
	
	public long getCaseId() {
		return this.caseId;
	}

	public void setCaseId(long caseId) {
		this.caseId = caseId;
	}

	public String getSrcTable() {
		return this.srcTable;
	}

	public void setSrcTable(String srcTable) {
		this.srcTable = srcTable;
	}

	public List<CaseAddress> getCaseAddresses() {
		return this.caseAddresses;
	}

	public void addCaseAddress(CaseAddress caseAddress) {
		caseAddress.setCaseLink(this);
		this.caseAddresses.add(caseAddress);
	}

	public CaseData getCaseData() {
		return this.caseData;
	}

	public void setCaseData(CaseData caseData) {
		this.caseData = caseData;
	}
	
	public CaseFlagApp getCaseFlagApp() {
		return this.caseFlagApp;
	}

	public void setCaseFlagApp(CaseFlagApp caseFlagApp) {
		this.caseFlagApp = caseFlagApp;
	}

	public CaseInsurance getCaseInsurance() {
		return this.caseInsurance;
	}

	public void setCaseInsurance(CaseInsurance caseInsurance) {
		this.caseInsurance = caseInsurance;
	}

	public CaseType getCaseType() {
		return this.caseType;
	}

	public void setCaseType(CaseType caseType) {
		this.caseType = caseType;
	}

	public SourceSystem getSourceSystem() {
		return this.sourceSystem;
	}

	public void setSourceSystem(SourceSystem sourceSystem) {
		this.sourceSystem = sourceSystem;
	}

	public LockedStatus getLockedStatus() {
		return lockedStatus;
	}

	public void setLockedStatus(LockedStatus lockedStatus) {
		this.lockedStatus = lockedStatus;
	}
	
	public FnodRecord getFnodRecord() {
		return this.fnodRecord;
	}

	public void setFnodRecord(FnodRecord fnodRecord) {
		fnodRecord.setCaseLink(this);
		this.fnodRecord = fnodRecord;
	}

	public List<CaseAttachment> getCaseAttachments() {
		return this.caseAttachments;
	}

	public void addCaseAttachment(CaseAttachment caseAttachment) {
		caseAttachment.setCaseLink(this);
		this.caseAttachments.add(caseAttachment);
	}

	public List<AuditActivity> getAuditActivity() {
		return this.auditActivity;
	}

	public void addAuditActivity(AuditActivity auditActivity) {
		auditActivity.setCaseLink(this);
		this.auditActivity.add(auditActivity);
	}

	public Timestamp getLoadDate() {
		return loadDate;
	}

	public void setLoadDate(Timestamp loadDate) {
		this.loadDate = loadDate;
	}	
	
}