package gov.va.fnod.model.fnoddata;



import java.io.Serializable;

import java.sql.Timestamp;



import javax.persistence.Column;

import javax.persistence.Entity;

import javax.persistence.Id;

import javax.persistence.JoinColumn;

import javax.persistence.Lob;

import javax.persistence.NamedQueries;

import javax.persistence.NamedQuery;

import javax.persistence.OneToOne;

import javax.persistence.Table;



/**

 * The persistent class for the CASE_INSURANCE database table.

 * 

 */

@Entity

@Table(name = "CASE_INSURANCE")

@NamedQueries({

	@NamedQuery(name="CaseInsurance.All", query="select c from CaseInsurance c "),

	@NamedQuery(name="CaseInsurance.byCaseId", query="select c from CaseInsurance c where c.caseLink.caseId = :caseId")

})

public class CaseInsurance implements Serializable {

	private static final long serialVersionUID = 1L;



	@Id

	@OneToOne

	@JoinColumn(name="CASE_ID", nullable=false)

	private CaseLink caseLink;



	@Lob()

	private String comments;



	@Column(name = "ENTRY_DT", nullable = false)

	private Timestamp entryDt;

	

	@Column(name = "VETERAN_NAME", length = 9)

	private String veteranName;

	

	@Column(name = "NAME_ADDRESS_LINE_1", length = 22)

	private String nameAddressLine1;

	

	@Column(name = "NAME_ADDRESS_LINE_2", length = 23)

	private String nameAddressLine2;

	

	@Column(name = "NAME_ADDRESS_LINE_3", length = 23)

	private String nameAddressLine3;

	

	@Column(name = "NAME_ADDRESS_LINE_4", length = 18)

	private String nameAddressLine4;

	

	@Column(name = "NAME_ADDRESS_LINE_5", length = 18)

	private String nameAddressLine5;

	

	@Column(name = "CITY_AND_STATE", length = 23)

	private String cityAndState;

	

	@Column(name = "ZIP_OR_FOREIGN_CODE", length = 5)

	private String zipOrForeignCode;

	

	@Column(name = "VETERAN_BIRTH_DT", length = 30)

	private String veteranDateOfBirth;

	

	@Column(name = "VETERAN_DEATH_DT", length = 30)

	private String veteranDateOfDeath;

	

	@Column(name = "VETERAN_CLAIM_NUM", length = 9)

	private String veteranClaimNumber;

	

	@Column(name = "VETERAN_SOCIAL_SECURITY_NUM", length = 37)

	private String veteranSocialSecurityNumber;

	

	@Column(name = "MILITARY_SERVICE_NUM", length = 10)

	private String veteranMilitaryServiceNumber;



	@Column(name = "INSURANCE_FILE_NUMBER", length = 9)

	private String insuranceFileNumber;

	

	@Column(name = "SPOUSE_NAME", length = 25)

	private String spouseName;

	

	@Column(name = "SPOUSE_ADDRESS_LINE_1", length = 25)

	private String spouseAddressLine1;

	

	@Column(name = "SPOUSE_ADDRESS_LINE_2", length = 25)

	private String spouseAddressLine2;

	

	@Column(name = "SPOUSE_ADDRESS_LINE_3", length = 25)

	private String spouseAddressLine3;

	

	@Column(name = "SPOUSE_CITY_AND_STATE", length = 28)

	private String spouseCityAndState;

	

	@Column(name = "SPOUSE_ZIP", length = 5)

	private String spouseZip;



	public CaseInsurance() {

		

	}



	public String getCityAndState() {

		if (cityAndState != null) {

			return cityAndState;

		}

		else {

			return "";

		}

	}



	public String getComments() {

		return this.comments;

	}



	public Timestamp getEntryDt() {

		return this.entryDt;

	}



	public String getInsuranceFileNumber() {

		return this.insuranceFileNumber;

	}



	public String getNameAddressLine1() {

		return nameAddressLine1;

	}



	public String getNameAddressLine2() {

		return nameAddressLine2;

	}



	public String getNameAddressLine3() {

		return nameAddressLine3;

	}



	public String getNameAddressLine4() {

		if (nameAddressLine4 != null) {

			return nameAddressLine4;

		}

		else {

			return " ";

		}

	}



	public String getNameAddressLine5() {

		if (nameAddressLine5 != null) {

			return nameAddressLine5;

		}

		else {

			return " ";

		}

	}



	public String getSpouseAddressLine1() {

		return spouseAddressLine1;

	}



	public String getSpouseAddressLine2() {

		return spouseAddressLine2;

	}



	public String getSpouseAddressLine3() {

		return spouseAddressLine3;

	}



	public String getSpouseCityAndState() {

		return spouseCityAndState;

	}



	public String getSpouseName() {

		return spouseName;

	}



	public String getSpouseZip() {

		return spouseZip;

	}



	public String getVeteranClaimNumber() {

		return veteranClaimNumber;

	}



	public String getVeteranDateOfBirth() {

		return veteranDateOfBirth;

	}



	public String getVeteranDateOfDeath() {

		return veteranDateOfDeath;

	}



	public String getVeteranMilitaryServiceNumber() {

		return veteranMilitaryServiceNumber;

	}



	public String getVeteranName() {

		return veteranName;

	}



	public String getVeteranSocialSecurityNumber() {

		return veteranSocialSecurityNumber;

	}



	public String getZipOrForeignCode() {

		return zipOrForeignCode;

	}



	public void setCityAndState(String cityAndState) {

		this.cityAndState = cityAndState;

	}



	public void setComments(String comments) {

		this.comments = comments;

	}



	public void setEntryDt(Timestamp entryDt) {

		this.entryDt = entryDt;

	}

	

	public void setInsuranceFileNumber(String insuranceFileNumber) {

		this.insuranceFileNumber = insuranceFileNumber;

	}



	public void setNameAddressLine1(String nameAddressLine1) {

		this.nameAddressLine1 = nameAddressLine1;

	}



	public void setNameAddressLine2(String nameAddressLine2) {

		this.nameAddressLine2 = nameAddressLine2;

	}



	public void setNameAddressLine3(String nameAddressLine3) {

		this.nameAddressLine3 = nameAddressLine3;

	}



	public void setNameAddressLine4(String nameAddressLine4) {

		this.nameAddressLine4 = nameAddressLine4;

	}



	public void setNameAddressLine5(String nameAddressLine5) {

		this.nameAddressLine5 = nameAddressLine5;

	}



	public void setSpouseAddressLine1(String spouseAddressLine1) {

		this.spouseAddressLine1 = spouseAddressLine1;

	}



	public void setSpouseAddressLine2(String spouseAddressLine2) {

		this.spouseAddressLine2 = spouseAddressLine2;

	}



	public void setSpouseAddressLine3(String spouseAddressLine3) {

		this.spouseAddressLine3 = spouseAddressLine3;

	}



	public void setSpouseCityAndState(String spouseCityAndState) {

		this.spouseCityAndState = spouseCityAndState;

	}



	public void setSpouseName(String spouseName) {

		this.spouseName = spouseName;

	}



	public void setSpouseZip(String spouseZip) {

		this.spouseZip = spouseZip;

	}



	public void setVeteranClaimNumber(String veteranClaimNumber) {

		this.veteranClaimNumber = veteranClaimNumber;

	}



	public void setVeteranDateOfBirth(String veteranDateOfBirth) {

		this.veteranDateOfBirth = veteranDateOfBirth;

	}



	public void setVeteranDateOfDeath(String veteranDateOfDeath) {

		this.veteranDateOfDeath = veteranDateOfDeath;

	}



	public void setVeteranMilitaryServiceNumber(String veteranMilitaryServiceNumber) {

		this.veteranMilitaryServiceNumber = veteranMilitaryServiceNumber;

	}



	public void setVeteranName(String veteranName) {

		this.veteranName = veteranName;

	}



	public void setVeteranSocialSecurityNumber(String veteranSocialSecurityNumber) {

		this.veteranSocialSecurityNumber = veteranSocialSecurityNumber;

	}



	public void setZipOrForeignCode(String zipOrForeignCode) {

		this.zipOrForeignCode = zipOrForeignCode;

	}

	

	public CaseLink getCaseLink() {

		return caseLink;

	}



	public void setCaseLink(CaseLink caseLink) {

		this.caseLink = caseLink;

	}



}