package gov.va.fnod.model.fnoddata;

import java.io.Serializable;
import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name = "CASE_FLAG_APP")
public class CaseFlagApp implements Serializable {

	private static final long serialVersionUID = -4543662158963335872L;
	
	@Id
	@OneToOne
	@JoinColumn(name="CASE_ID", nullable=false)
	private CaseLink caseLink;
	
	@Column(name = "ENTRY_DT", nullable = false)
	private Timestamp entryDt;
	
	@Column(name = "REGION_ID")
	private long regionalId;
	
	@Column(name = "REGIONAL_OFFICE_ID")
	private long regionalOfficeId;
	
	@Column(name="SCAN_PROCESS_DT")
	Timestamp scanProcessDt;
	
	@Column(name="SCAN_BATCH_ID")
	private Long scanBatchId;
	
	@Column(name="SCAN_BATCH_DT")
	Timestamp scanBatchDt;
	
	@Column(name="SCAN_DOC_ID")
	private Long scanDocId;
	
	@Column(name="SCAN_DOC_DT")
	Timestamp scanDocDt;
	
	@Column(name = "DOC_STORAGE_ID", precision = 9)
	private long docStorageId;

	public CaseLink getCaseLink() {
		return caseLink;
	}

	public void setCaseLink(CaseLink caseLink) {
		this.caseLink = caseLink;
	}

	public Timestamp getEntryDt() {
		return entryDt;
	}

	public void setEntryDt(Timestamp entryDt) {
		this.entryDt = entryDt;
	}
	
	public long getRegionalId() {
		return regionalId;
	}
	
	public void setRegionalId(long regionalId) {
		this.regionalId = regionalId;
	}
	
	public long getRegionalOfficeId() {
		return regionalOfficeId;
	}
	
	public void setRegionalOfficeId(long regionalOfficeId) {
		this.regionalOfficeId = regionalOfficeId;
	}

	public long getDocStorageId() {
		return docStorageId;
	}

	public void setDocStorageId(long docStorageId) {
		this.docStorageId = docStorageId;
	}

	public Timestamp getScanProcessDt() {
		return scanProcessDt;
	}

	public void setScanProcessDt(Timestamp scanProcessDt) {
		this.scanProcessDt = scanProcessDt;
	}

	public Long getScanBatchId() {
		return scanBatchId;
	}

	public void setScanBatchId(Long scanBatchId) {
		this.scanBatchId = scanBatchId;
	}

	public Timestamp getScanBatchDt() {
		return scanBatchDt;
	}

	public void setScanBatchDt(Timestamp scanBatchDt) {
		this.scanBatchDt = scanBatchDt;
	}

	public Long getScanDocId() {
		return scanDocId;
	}

	public void setScanDocId(Long scanDocId) {
		this.scanDocId = scanDocId;
	}

	public Timestamp getScanDocDt() {
		return scanDocDt;
	}

	public void setScanDocDt(Timestamp scanDocDt) {
		this.scanDocDt = scanDocDt;
	}

}
