package gov.va.fnod.model.fnoddata;

import java.io.Serializable;
import javax.persistence.*;
import java.sql.Timestamp;

/**
 * The persistent class for the CASE_DATA database table.
 * 
 */
@Entity
@Table(name = "CASE_DATA")
@NamedQueries({
	@NamedQuery(name="CaseData.All", query="select c from CaseData c "),
	@NamedQuery(name="CaseData.byCaseId", query="select c from CaseData c where c.caseLink.caseId = :caseId")
})
public class CaseData implements Serializable {
	private static final long serialVersionUID = 1L;
	
	@Id
	@OneToOne
	@JoinColumn(name="CASE_ID", nullable=false)
	private CaseLink caseLink;

	@Column(name = "CEMETERY_NAME", length = 50)
	private String cemeteryName;

	@Column(name = "CEMETERY_NUM", length = 3)
	private String cemeteryNum;

	@Column(name = "CEMETERY_TYPE", length = 1)
	private String cemeteryType;

	@Lob()
	private String comments;

	@Column(name = "ENTRY_DT", nullable = false)
	private Timestamp entryDt;

	@Column(name = "SOURCE_USER_ID", length = 8)
	private String sourceUserId;

	@Column(name = "VETERAN_HOME_OF_RECORD_CITY", length = 30)
	private String veteranHomeOfRecordCity;

	@Column(name = "VETERAN_HOME_OF_RECORD_STATE", length = 20)
	private String veteranHomeOfRecordState;

	@Embedded
	@AttributeOverrides({
		@AttributeOverride(name="firstName", column=@Column(name="VETERAN_FIRST_NAME")),
		@AttributeOverride(name="lastName", column=@Column(name="VETERAN_LAST_NAME")),
		@AttributeOverride(name="middleName", column=@Column(name="VETERAN_MIDDLE_NAME")),
		@AttributeOverride(name="suffixName", column=@Column(name="VETERAN_SUFFIX_NAME")),
		@AttributeOverride(name="socialSecurityNumber", column=@Column(name="VETERAN_SOCIAL_SECURITY_NUM")),
		@AttributeOverride(name="decedentId", column=@Column(name="VETERAN_DECEDENT_ID")),
		@AttributeOverride(name="birthDt", column=@Column(name="VETERAN_BIRTH_DT")),
		@AttributeOverride(name="deathDt", column=@Column(name="VETERAN_DEATH_DT")),
		@AttributeOverride(name="recordOfIntermentDt", column=@Column(name="VETERAN_RECORD_OF_INTERMENT_DT"))
	})
	private Person veteranPerson;
	
	@Embedded
	@AttributeOverrides({
		@AttributeOverride(name="firstName", column=@Column(name="SPOUSE_FIRST_NAME")),
		@AttributeOverride(name="lastName", column=@Column(name="SPOUSE_LAST_NAME")),
		@AttributeOverride(name="middleName", column=@Column(name="SPOUSE_MIDDLE_NAME")),
		@AttributeOverride(name="suffixName", column=@Column(name="SPOUSE_SUFFIX_NAME")),
		@AttributeOverride(name="socialSecurityNumber", column=@Column(name="SPOUSE_SOCIAL_SECURITY_NUM")),
		@AttributeOverride(name="decedentId", column=@Column(name="SPOUSE_DECEDENT_ID")),
		@AttributeOverride(name="birthDt", column=@Column(name="SPOUSE_BIRTH_DT")),
		@AttributeOverride(name="deathDt", column=@Column(name="SPOUSE_DEATH_DT")),
		@AttributeOverride(name="recordOfIntermentDt", column=@Column(name="SPOUSE_RECORD_OF_INTERMENT_DT"))
	})
	private Person spousePerson;
	
	@Embedded
	private Veteran veteran;

	public CaseLink getCaseLink() {
		return caseLink;
	}
	
	public long getCaseId() {
		return caseLink.getCaseId();
	}

	public String getCemeteryName() {
		return this.cemeteryName;
	}

	public String getCemeteryNum() {
		return this.cemeteryNum;
	}

	public String getCemeteryType() {
		return this.cemeteryType;
	}

	public String getComments() {
		return this.comments;
	}

	public Timestamp getEntryDt() {
		return this.entryDt;
	}

	public String getSourceUserId() {
		return this.sourceUserId;
	}

	public Person getSpousePerson() {
		return spousePerson;
	}

	public Veteran getVeteran() {
		return veteran;
	}

	public String getVeteranHomeOfRecordCity() {
		return this.veteranHomeOfRecordCity;
	}

	public String getVeteranHomeOfRecordState() {
		return this.veteranHomeOfRecordState;
	}

	public Person getVeteranPerson() {
		return veteranPerson;
	}

	public void setCaseLink(CaseLink caseLink) {
		this.caseLink = caseLink;
	}

	public void setCemeteryName(String cemeteryName) {
		this.cemeteryName = cemeteryName;
	}

	public void setCemeteryNum(String cemeteryNum) {
		this.cemeteryNum = cemeteryNum;
	}

	public void setCemeteryType(String cemeteryType) {
		this.cemeteryType = cemeteryType;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public void setEntryDt(Timestamp entryDt) {
		this.entryDt = entryDt;
	}

	public void setSourceUserId(String sourceUserId) {
		this.sourceUserId = sourceUserId;
	}

	public void setSpousePerson(Person spousePerson) {
		this.spousePerson = spousePerson;
	}
	
	public void setVeteran(Veteran veteran) {
		this.veteran = veteran;
	}

	public void setVeteranHomeOfRecordCity(String veteranHomeOfRecordCity) {
		this.veteranHomeOfRecordCity = veteranHomeOfRecordCity;
	}

	public void setVeteranHomeOfRecordState(String veteranHomeOfRecordState) {
		this.veteranHomeOfRecordState = veteranHomeOfRecordState;
	}

	public void setVeteranPerson(Person veteranPerson) {
		this.veteranPerson = veteranPerson;
	}
}