package gov.va.fnod.model.fnoddata;



import java.io.Serializable;

import java.util.Date;



import javax.persistence.Column;

import javax.persistence.Entity;

import javax.persistence.GeneratedValue;

import javax.persistence.GenerationType;

import javax.persistence.Id;

import javax.persistence.JoinColumn;

import javax.persistence.ManyToOne;

import javax.persistence.SequenceGenerator;

import javax.persistence.Table;

import javax.persistence.Temporal;

import javax.persistence.TemporalType;



/**

 * The persistent class for the CASE_ATTACHMENT database table.

 * 

 */

@Entity

@Table(name="CASE_ATTACHMENT")

public class CaseAttachment implements Serializable {

	private static final long serialVersionUID = 1L;

	

	@Id

	@SequenceGenerator(name = "CASE_ATTACHMENT_CASEATTACHMENTID_GENERATOR", sequenceName = "CASE_ATTACHMENT_SEQ", allocationSize = 1)

	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "CASE_ATTACHMENT_CASEATTACHMENTID_GENERATOR")

	@Column(name="CASE_ATTACHMENT_ID", unique=true, nullable=false)

	private Long caseAttachmentId;

	

	//bi-directional many-to-one association to CaseLink

	@ManyToOne

	@JoinColumn(name="CASE_ID", nullable=false)

	private CaseLink caseLink;

	

	@ManyToOne

	@JoinColumn(name="ATTACHMENT_TYPE_ID")

	private AttachmentType attachmentType;

	

	@Column(name="ATTACHED_BY")

	private String attachedBy;

	

	@Column(name="ATTACHED_DATE")

	@Temporal(TemporalType.DATE)

	private Date attachedDate;

	

	@Column(name="FILE_NAME")

	private String fileName;

	

	@Column(name="DOCUMENT_STORAGE_ID")

	private Long documentStorageId;

	

	@Column(name="COMMENTS")

	private String comments;

	

	public CaseAttachment() {

	}

	

	public CaseAttachment(AttachmentType attachmentType, String attachedBy, Date attachedDate, String fileName, String comments) {

		this.attachmentType = attachmentType;

		this.attachedBy = attachedBy;

		this.attachedDate = attachedDate;

		this.fileName = fileName;

		this.comments = comments;

	}

	

	public Long getCaseAttachmentId() {

		return caseAttachmentId;

	}



	public void setCaseAttachmentId(Long caseAttachmentId) {

		this.caseAttachmentId = caseAttachmentId;

	}



	public CaseLink getCaseLink() {

		return this.caseLink;

	}



	public void setCaseLink(CaseLink caseLink) {

		this.caseLink = caseLink;

	}



	public AttachmentType getAttachmentType() {

		return attachmentType;

	}



	public void setAttachmentType(AttachmentType attachmentType) {

		this.attachmentType = attachmentType;

	}



	public String getAttachedBy() {

		return attachedBy;

	}



	public void setAttachedBy(String attachedBy) {

		this.attachedBy = attachedBy;

	}



	public Date getAttachedDate() {

		return attachedDate;

	}



	public void setAttachedDate(Date attachedDate) {

		this.attachedDate = attachedDate;

	}



	public String getFileName() {

		return fileName;

	}



	public void setFileName(String fileName) {

		this.fileName = fileName;

	}



	public Long getDocumentStorageId() {

		return documentStorageId;

	}



	public void setDocumentStorageId(Long documentStorageId) {

		this.documentStorageId = documentStorageId;

	}



	public String getComments() {

		return comments;

	}



	public void setComments(String comments) {

		this.comments = comments;

	}



	@Override

	public String toString() {

		return fileName + ", " + attachedDate + ", " + attachedBy + " (" + (documentStorageId!=null ? documentStorageId.toString() : "null" ) + ")";

	}

	

	@Override

	public boolean equals(Object object) {

		if (object == null) {

			return false;

		}

		

		CaseAttachment caseAttachment = (CaseAttachment)object;

		

		return toString().equals(caseAttachment.toString());

	}

	

	@Override

	public int hashCode() {

		return toString().hashCode();

	}

}