package gov.va.fnod.model.fnoddata;

import java.io.Serializable;
import javax.persistence.*;

/**
 * The persistent class for the CASE_ADDRESS database table.
 * 
 */
@Entity
@Table(name = "CASE_ADDRESS")
public class CaseAddress implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@SequenceGenerator(name = "CASE_ADDRESS_CASEADDRESSID_GENERATOR", sequenceName = "CASE_ADDRESS_SEQ", allocationSize = 1)
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "CASE_ADDRESS_CASEADDRESSID_GENERATOR")
	@Column(name="CASE_ADDRESS_ID", unique=true, nullable=false, precision=9)
	private long caseAddressId;

	@Column(name="ADDRESS_TYPE", nullable=false, length=1)
	private String addressType;

	//bi-directional many-to-one association to CaseLink
	@ManyToOne
	@JoinColumn(name="CASE_ID", nullable=false)
	private CaseLink caseLink;

	@Embedded
	@AttributeOverrides({
		@AttributeOverride(name="line1", column=@Column(name="LINE_ONE_ADDR")),
		@AttributeOverride(name="line2", column=@Column(name="LINE_TWO_ADDR")),
		@AttributeOverride(name="line3", column=@Column(name="LINE_THREE_ADDR")),
		@AttributeOverride(name="line4", column=@Column(name="LINE_FOUR_ADDR")),
		@AttributeOverride(name="line5", column=@Column(name="LINE_FIVE_ADDR")),
		@AttributeOverride(name="city", column=@Column(name="CITY")),
		@AttributeOverride(name="stateProvCd", column=@Column(name="STATE_PROV_CD")),
		@AttributeOverride(name="zipCode", column=@Column(name="ZIP_CODE")),
		@AttributeOverride(name="foreignMailCode", column=@Column(name="FOREIGN_MAIL_CODE"))
	})
	private Address address;

	public CaseAddress() {
	}

	public long getCaseAddressId() {
		return this.caseAddressId;
	}

	public void setCaseAddressId(long caseAddressId) {
		this.caseAddressId = caseAddressId;
	}

	public String getAddressType() {
		return this.addressType;
	}

	public void setAddressType(String addressType) {
		this.addressType = addressType;
	}

	public CaseLink getCaseLink() {
		return this.caseLink;
	}

	public void setCaseLink(CaseLink caseLink) {
		this.caseLink = caseLink;
	}
	
	public Address getAddress() {
		return address;
	}

	public void setAddress(Address address) {
		this.address = address;
	}
}