package gov.va.fnod.model.fnoddata;

import java.io.Serializable;
import javax.persistence.*;

/**
 * The persistent class for the AUDIT_CHANGE database table.
 * 
 */
@Entity
@Table(name = "AUDIT_CHANGE")
public class AuditChange implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@SequenceGenerator(name = "AUDIT_CHANGE_AUDITCHANGEID_GENERATOR", sequenceName = "AUDIT_CHANGE_SEQ", allocationSize = 1)
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "AUDIT_CHANGE_AUDITCHANGEID_GENERATOR")
	@Column(name = "AUDIT_CHANGE_ID", unique = true, nullable = false, precision = 9)
	private long auditChangeId;

	@Column(name = "FIELD_NAME", nullable = false, length = 30)
	private String fieldName;

	@Column(name = "NEW_VALUE", length = 100)
	private String newValue;

	@Column(name = "ORIG_VALUE", length = 100)
	private String origValue;

	// bi-directional many-to-one association to AuditActivity
	@ManyToOne
	@JoinColumn(name = "TRANSACTION_ID", nullable = false)
	private AuditActivity auditActivity;
	
	public AuditChange() {
	}
	
	public AuditChange(AuditActivity auditActivity, String fieldName, String origValue, String newValue) {
		this.auditActivity = auditActivity;
		this.fieldName = fieldName;
		this.origValue = origValue;
		this.newValue= newValue;
	}

	public long getAuditChangeId() {
		return this.auditChangeId;
	}

	public void setAuditChangeId(long auditChangeId) {
		this.auditChangeId = auditChangeId;
	}

	public String getFieldName() {
		return this.fieldName;
	}

	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}

	public String getNewValue() {
		return this.newValue;
	}

	public void setNewValue(String newValue) {
		this.newValue = newValue;
	}

	public String getOrigValue() {
		return this.origValue;
	}

	public void setOrigValue(String origValue) {
		this.origValue = origValue;
	}

	public AuditActivity getAuditActivity() {
		return this.auditActivity;
	}

	public void setAuditActivity(AuditActivity auditActivity) {
		this.auditActivity = auditActivity;
	}

}