package gov.va.fnod.model.fnoddata;

import java.io.Serializable;

import javax.persistence.*;

/**
 * The persistent class for the ATTACHMENT_TYPE database table.
 * 
 */
@Entity
@Table(name="ATTACHMENT_TYPE")
@NamedQuery(name=AttachmentType.GET_ALL_ATTACHMENTS, query="select a from AttachmentType a ")
public class AttachmentType implements Serializable {
	private static final long serialVersionUID = 1L;
	
	public static final String GET_ALL_ATTACHMENTS = "GET_ALL_ATTACHMENTS";
	
	@Id
	@Column(name="ATTACHMENT_TYPE_ID", unique=true, nullable=false)
	private String attachmentTypeId;
	
	@Column(name="DESCRIPTION")
	private String description;

	public String getAttachmentTypeId() {
		return attachmentTypeId;
	}

	public void setAttachmentTypeId(String attachmentTypeId) {
		this.attachmentTypeId = attachmentTypeId;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	@Override
	public String toString() {
		return description;
	}
	
	@Override
	public boolean equals(Object object) {
		if (object == null) {
			return false;
		}
		
		AttachmentType attachmentType = (AttachmentType)object;
		
		return toString().equals(attachmentType.toString());
	}
	
	@Override
	public int hashCode() {
		return toString().hashCode();
	}
}