package gov.va.fnod.model.fnoddata;

import java.io.Serializable;
import javax.persistence.*;

/**
 * The persistent class for the APP_USER_ROLE database table.
 * 
 */
@Entity
@Table(name = "APP_USER_ROLE")
@NamedQuery(name="AppUserRole.byUsername", query="select u from AppUserRole u where u.appUser.username = :username")
public class AppUserRole implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@SequenceGenerator(name = "APP_USER_ROLE_APPUSERROLEID_GENERATOR", sequenceName = "APP_USER_ROLE_SEQ", allocationSize=1)
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "APP_USER_ROLE_APPUSERROLEID_GENERATOR")
	@Column(name = "APP_USER_ROLE_ID", unique = true, nullable = false, precision = 9)
	private long appUserRoleId;

	// uni-directional many-to-one association to AppRole
	@ManyToOne
	@JoinColumn(name = "ROLE_ID",  nullable = false)
	private AppRole appRole;

	// bi-directional many-to-one association to AppUser
	@ManyToOne
	@JoinColumn(name = "USER_ID",  nullable = false)
	private AppUser appUser;

	public AppUserRole() {
	}

	public long getAppUserRoleId() {
		return this.appUserRoleId;
	}

	public void setAppUserRoleId(long appUserRoleId) {
		this.appUserRoleId = appUserRoleId;
	}

	public AppRole getAppRole() {
		return this.appRole;
	}

	public void setAppRole(AppRole appRole) {
		this.appRole = appRole;
	}

	public AppUser getAppUser() {
		return this.appUser;
	}

	public void setAppUser(AppUser appUser) {
		this.appUser = appUser;
	}

}