package gov.va.fnod.model.fnoddata;

import gov.va.fnod.model.UserRole;
import gov.va.fnod.security.LoginStatus;
import gov.va.fnod.security.authentication.UserInitialContext;
import gov.va.fnod.security.authentication.UserPswdChangeContext;
import gov.va.fnod.security.authorization.UserRoleContext;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * The persistent class for the APP_USER database table.
 */
@Entity
@Table(name = "APP_USER")
@NamedQueries({
	@NamedQuery(name = AppUser.GET_ALL_APP_USERS,
				query = "select u from AppUser u"),
	@NamedQuery(name = AppUser.GET_PARKING_LOT_APP_USERS,
				query = "select u from AppUser u " +
						"where u.username in (" +
						"  select distinct c.fnodRecord.username " +
						"  from CaseLink c " +
						"  where c.lockedStatus = :lockedStatus" +
						")"),
	@NamedQuery(name = AppUser.GET_APP_USER_BY_USERNAME, 
				query = "select u from AppUser u where u.username = :username")
})
@NamedNativeQueries({
	
	@NamedNativeQuery(name=AppUser.GET_ALL_USERS_ADMIN_CAN_EDIT, query="select u.* "
		+ "from fnod_data.app_user u "
		+ "where u.username <> ? and u.username like ?"
		+ " and not exists ( select ur.role_id "
		+ " from fnod_data.app_user_role ur "
		+ " join fnod_data.app_role r on ur.role_id = r.role_id "
		+ " where r.role_user = 'N' "
		+ " and ur.user_id = u.user_id )", resultClass=AppUser.class)
 
})
public class AppUser implements Serializable, UserInitialContext, UserPswdChangeContext, UserRoleContext<UserRole> {
	private static final long serialVersionUID = 1L;
	
	public static final String GET_APP_USER_BY_USERNAME = "GET_APP_USER_BY_USERNAME";
	public static final String GET_ALL_APP_USERS = "GET_ALL_APP_USERS";
	public static final String GET_PARKING_LOT_APP_USERS = "GET_PARKING_LOT_APP_USERS";
	public static final String GET_ALL_USERS_ADMIN_CAN_EDIT = "GET_ALL_USERS_ADMIN_CAN_EDIT";
	
	@Id
	@SequenceGenerator(name = "APP_USER_USERID_GENERATOR", sequenceName = "APP_USER_SEQ", allocationSize = 1)
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "APP_USER_USERID_GENERATOR")
	@Column(name = "USER_ID", unique = true, nullable = false, precision = 9)
	private long userId;

	@Column(name = "DISPLAY_NAME", nullable = false, length = 50)
	private String displayName;

	@Column(name = "EMAIL_ADDRESS", length = 50)
	private String emailAddress;

	@Column(name = "EXPIRY_DATE", nullable = false)
	private Timestamp expiryDate;

	@Column(name = "LOCKED_TIME")
	private Timestamp lockedTime;

	@Column(nullable = false, length = 80)
	private String password;

	@Column(name = "PASSWORD_HISTORY", length = 4000)
	private String passwordHistory;

	@Column(name = "PHONE_NUM", length = 20)
	private String phoneNum;

	@Column(nullable = false, length = 20)
	private String status;

	@Column(name = "USER_CREATED_DT", nullable = false)
	private Timestamp userCreatedDt;

	@Column(name = "USER_UPDATE_DT", nullable = false)
	private Timestamp userUpdateDt;

	@Column(unique = true, nullable = false, length = 32)
	private String username;
	
	@Column(name = "LOGIN_ATTEMPTS", precision = 9)
	private int loginAttempts;
	
	@Column(name = "PASSWORD_CHANGED_DATE")
	private Timestamp passwordChangedDate;
	
	@Column(name = "LAST_LOGIN_DT")
	private Timestamp lastLoginDate;
	
	@Transient
	private boolean lockUnlockAct;
	
	// bi-directional many-to-one association to AppUserRole
	@OneToMany(mappedBy = "appUser", fetch=FetchType.LAZY, cascade=CascadeType.ALL, orphanRemoval=true)
	private List<AppUserRole> appUserRoles;
	
	public AppUser() {
	}

	public long getUserId() {
		return this.userId;
	}

	public void setUserId(long userId) {
		this.userId = userId;
	}

	public String getDisplayName() {
		return this.displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public String getEmailAddress() {
		return this.emailAddress;
	}

	public void setEmailAddress(String emailAddress) {
		this.emailAddress = emailAddress;
	}

	/**
	 * @return the expiryDate
	 */
	public Timestamp getExpiryDate() {
		return expiryDate;
	}

	/**
	 * @param expiryDate the expiryDate to set
	 */
	public void setExpiryDate(Timestamp expiryDate) {
		this.expiryDate = expiryDate;
	}

	public Timestamp getLockedTime() {
		return this.lockedTime;
	}

	public void setLockedTime(Timestamp lockedTime) {
		this.lockedTime = lockedTime;
	}

	public String getPassword() {
		return this.password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getPasswordHistory() {
		return this.passwordHistory;
	}

	public void setPasswordHistory(String passwordHistory) {
		this.passwordHistory = passwordHistory;
	}

	public String getPhoneNum() {
		return this.phoneNum;
	}

	public void setPhoneNum(String phoneNum) {
		this.phoneNum = phoneNum;
	}

	public String getStatus() {
		return this.status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	/**
	 * @return the userCreatedDt
	 */
	public Timestamp getUserCreatedDt() {
		return userCreatedDt;
	}

	/**
	 * @param userCreatedDt the userCreatedDt to set
	 */
	public void setUserCreatedDt(Timestamp userCreatedDt) {
		this.userCreatedDt = userCreatedDt;
	}

	/**
	 * @return the userUpdateDt
	 */
	public Timestamp getUserUpdateDt() {
		return userUpdateDt;
	}

	/**
	 * @param userUpdateDt the userUpdateDt to set
	 */
	public void setUserUpdateDt(Timestamp userUpdateDt) {
		this.userUpdateDt = userUpdateDt;
	}

	public String getUsername() {
		return this.username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public List<AppUserRole> getAppUserRoles() {
		return this.appUserRoles;
	}

	public void setAppUserRoles(List<AppUserRole> appUserRoles) {
		this.appUserRoles = appUserRoles;
	}

	/**
	 * @return the lockUnlockAct
	 */
	public boolean isLockUnlockAct() {
		return lockUnlockAct;
	}

	/**
	 * @param lockUnlockAct the lockUnlockAct to set
	 */
	public void setLockUnlockAct(boolean lockUnlockAct) {
		this.lockUnlockAct = lockUnlockAct;
	}

	/**
	 * @return the loginAttempts
	 */
	@Override
	public int getLoginAttempts() {
		return loginAttempts;
	}

	/**
	 * @param loginAttempts the loginAttempts to set
	 */
	@Override
	public void setLoginAttempts(int loginAttempts) {
		this.loginAttempts = loginAttempts;
	}

	/**
	 * @return the passwordChangedDate
	 */
	public Timestamp getPasswordChangedDate() {
		return passwordChangedDate;
	}

	/**
	 * @param passwordChangedDate the passwordChangedDate to set
	 */
	public void setPasswordChangedDate(Timestamp passwordChangedDate) {
		this.passwordChangedDate = passwordChangedDate;
	}
	
	@Override
	public String toString() {
		return username;
	}
	
	@Override
	public boolean equals(Object object) {
		if (object == null) {
			return false;
		}
		
		if (!(object instanceof AppUser)) {
			return false;
		}
		
		AppUser user = (AppUser)object;
		
		if (user == null || user.username == null) {
			return false;
		}
		
		return username.equals(user.username);
	}
	
	@Override
	public int hashCode() {
		if (username == null) {
			return -1;
		}
		
		return username.hashCode();
	}

	@Override
	public String getUserName() {
		return username;
	}

	@Override
	public String getPswdHash() {
		return password;
	}

	@Override
	public LoginStatus getLoginStatus() {
		
		return LoginStatus.valueOf(status);
	}

	@Override
	public void setLoginStatus(LoginStatus status) {
		this.status = status.name(); 		
	}

	@Override
	public Date getTimeLockedDate() {
		return lockedTime;
	}

	@Override
	public void setTimeLockedDate(Date timeTempLocked) {
		if ( timeTempLocked != null  ) {
			lockedTime = new Timestamp(timeTempLocked.getTime());
		} else {
			lockedTime = null;
		}
	}

	@Override
	public Date getLastLoginDate() {
		return this.lastLoginDate;
	}

	@Override
	public void setLastLoginDate(Date loginDate) {
		if ( loginDate != null ) {
			lastLoginDate = new Timestamp(loginDate.getTime());
		}
	}

	@Override
	public void setPswdHash(String pswdHash) {
		this.password = pswdHash;		
	}

	@Override
	public List<String> getPswdHistory() {
		List<String> retval = new ArrayList<String>();
		if ( passwordHistory != null ) {
			retval.addAll(Arrays.asList(passwordHistory.split("\\|")));
		}				
		return retval; 
	}

	@Override
	public void setPswdHistory(List<String> pswdHistory) {
		if ( ! pswdHistory.isEmpty() ) {
			StringBuilder sb = new StringBuilder();
		
			for( String pswdHash: pswdHistory ) {
				sb.append('|').append(pswdHash);
			}
			passwordHistory = sb.substring(1);			
		} else {
			passwordHistory = null;
		}		
	}

	@Override
	public Date getLastPswdChangeDate() {		
		return passwordChangedDate;
	}

	@Override
	public void setLastPswdChangeDate(Date lastPswdChangeDate) {
		if ( lastPswdChangeDate == null ) {
			passwordChangedDate = null;
		} else {
			passwordChangedDate = new Timestamp(lastPswdChangeDate.getTime());
		}		
	}

	@Override
	public void setExpiryDate(Date expiryDate) {
		if ( expiryDate == null ) {
			this.expiryDate = null;
		} else {
			this.expiryDate = new Timestamp(expiryDate.getTime());
		}		
	}

	@Override
	public Set<UserRole> getRoles() {
		Set<UserRole> roles = new HashSet<UserRole>();
		for (AppUserRole userRole: getAppUserRoles() ) {
			roles.add(UserRole.valueOf(userRole.getAppRole().getRoleCd()));			
		}
		return EnumSet.copyOf(roles);
	}

}