package gov.va.fnod.model.fnoddata;

import java.io.Serializable;
import javax.persistence.*;


/**
 * The persistent class for the APP_ROLE database table.
 * 
 */
@Entity
@Table(name = "APP_ROLE")

@NamedQuery(name=AppRole.GET_ALL_APP_ROLES, query="select r from AppRole r ")
public class AppRole implements Serializable {
	private static final long serialVersionUID = 1L;
	
	public static final String GET_ALL_APP_ROLES = "GET_ALL_APP_ROLES";

	@Id
	@Column(name="ROLE_ID", unique=true, nullable=false, precision=9)
	private long roleId;

	@Column(nullable=false, length=50)
	private String description;

	@Column(name="ROLE_CD", unique=true, nullable=false, length=32)
	private String roleCd;
	
	@Column(name="ROLE_USER", nullable=false, length = 1)
	private String roleUser;
	
	public AppRole() {
    }

	public long getRoleId() {
		return this.roleId;
	}

	public void setRoleId(long roleId) {
		this.roleId = roleId;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getRoleCd() {
		return this.roleCd;
	}

	public void setRoleCd(String roleCd) {
		this.roleCd = roleCd;
	}

	/**
	 * @return the roleUser
	 */
	public String getRoleUser() {
		return roleUser;
	}

	/**
	 * @param roleUser the roleUser to set
	 */
	public void setRoleUser(String roleUser) {
		this.roleUser = roleUser;
	}

}