package gov.va.fnod.model.fnoddata;

/**
 * 
 * @author Jim Lindelof
 *
 */
public enum ActivityTypeCode {
	
	/**
	 * Record was assigned to a user, this could be the initial assignment, or subsequent re-assignment
	 */
	ASSIGNED(false, false),

	/**
	 * This activity results from a user entering a case from the search and updating the FNOD Record  
	 */
	CORRECTION(false, false),
	
	/**
	 * Record was reviewed as part of a Sample Pending Audit
	 */
	SAMPLED_PENDING(true, true),  

	/**
	 * The case was audited because money were captured.
	 */
	AUDITED_AWARD(true, true),
		
	/**
	 * Completed FNOD Record was audited as part of a sample
	 */
	AUDITED_FNOD(true, true);
		
	private boolean forceActivityIfNoChange;
	private boolean auditActivity;
	
	private ActivityTypeCode(boolean forceActivityIfNoChange, boolean auditActivity) {
		this.forceActivityIfNoChange = forceActivityIfNoChange;
		this.auditActivity = auditActivity;
	}
	
	public boolean isForceActivityIfNoChange() {
		return forceActivityIfNoChange;
	}
	
	public boolean isAuditActivity() {
		return auditActivity;
	}
	
}
