package gov.va.fnod.model.fnoddata;

import java.io.Serializable;
import javax.persistence.*;

/**
 * The persistent class for the AUDIT_CHANGE database table.
 * 
 */
@Entity
@Table(name = "ACTIVITY_TYPE")
@NamedQuery(name = ActivityType.GET_ACTIVITY_TYPE_BY_ACTIVITY_CODE, 
			query = "select a from ActivityType a where a.activityCd = :activityCd")
public class ActivityType implements Serializable {
	private static final long serialVersionUID = 1L;
	
	public static final String GET_ACTIVITY_TYPE_BY_ACTIVITY_CODE = "GET_ACTIVITY_TYPE_BY_ACTIVITY_CODE";

	@Id
	@Column(name = "ACTIVITY_TYPE_ID", unique = true, nullable = false, precision = 9)
	private long activityTypeId;
	
	@Column(name = "ACTIVITY_CD", unique = true, nullable = false, length = 20)
	@Enumerated(EnumType.STRING)
	private ActivityTypeCode activityCd;
	
	@Column(name = "DESCRIPTION", nullable = false, length = 40)
	private String description;

	public ActivityType() {
	}
	
	public long getActivityTypeId() {
		return this.activityTypeId;
	}

	public void setActivityTypeId(long activityTypeId) {
		this.activityTypeId = activityTypeId;
	}

	public ActivityTypeCode getActivityCd() {
		return activityCd;
	}

	public void setActivityCd(ActivityTypeCode activityCd) {
		this.activityCd = activityCd;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
}