package gov.va.fnod.model.app;

import java.io.Serializable;
import java.util.Date;

/**
 * Represents a row in the aggregate counts table, which lists the number of CaseLink records that are in a 
 * parked state for each application category (BOSS, BOSS Spouse, AMAS, AMAS Spouse, Insurance, Flag App, etc...)
 * 
 * @author VHAISLHODGEJ
 *
 */
public class AggregateCountItem implements Serializable {

	private static final long serialVersionUID = 75648211132L;
	
	Integer caseTypeId;
	Integer totalCaseCount;
	Integer pending;
	Integer parked;
	Date loadDate;
	Integer sourceSystemId;
	Integer sourceCaseTypeMapId;
	Integer regionId;
	Integer regionalOfficeId;
	String regionalOfficeName;

	public AggregateCountItem() {
		super();
	}

	public Integer getCaseTypeId() {
		return caseTypeId;
	}

	public void setCaseTypeId(Integer caseType) {
		this.caseTypeId = caseType;
	}

	public Integer getTotalCaseCount() {
		return totalCaseCount;
	}

	public void setTotalCaseCount(Integer totalCaseCount) {
		this.totalCaseCount = totalCaseCount;
	}

	public Integer getPending() {
		return pending;
	}

	public void setPending(Integer pending) {
		this.pending = pending;
	}

	public Integer getParked() {
		return parked;
	}

	public void setParked(Integer parked) {
		this.parked = parked;
	}

	public Date getLoadDate() {
		return loadDate;
	}

	public void setLoadDate(Date loadDate) {
		this.loadDate = loadDate;
	}

	public Integer getSourceSystemId() {
		return sourceSystemId;
	}

	public void setSourceSystemId(Integer sourceSystem) {
		this.sourceSystemId = sourceSystem;
	}

	public Integer getSourceCaseTypeMapId() {
		return sourceCaseTypeMapId;
	}

	public void setSourceCaseTypeMapId(Integer sourceCaseTypeMapId) {
		this.sourceCaseTypeMapId = sourceCaseTypeMapId;
	}

	public Integer getRegionId() {
		return regionId;
	}

	public void setRegionId(Integer regionId) {
		this.regionId = regionId;
	}

	public Integer getRegionalOfficeId() {
		return regionalOfficeId;
	}

	public void setRegionalOfficeId(Integer regionalOfficeId) {
		this.regionalOfficeId = regionalOfficeId;
	}

	public String getRegionalOfficeName() {
		return regionalOfficeName;
	}

	public void setRegionalOfficeName(String regionalOfficeName) {
		this.regionalOfficeName = regionalOfficeName;
	}

}
