package gov.va.fnod.model;

import java.util.Map;

public interface Validator {

	void setPasswordHasher(PasswordHashable passwordHasher);

	/**
	 * validate password
	 * @param password
	 * @param passwordData
	 * @return
	 */
	Map<ErrorCode, String> validatePassword(String password,
			PasswordData passwordData);
	
	/**
	 * validate change password
	 * @param newPassword
	 * @param passwordData
	 * @return
	 */
	Map<ErrorCode, String> validateChangePassword(String newPassword,
			PasswordData passwordData);

	/**
	 * validate create user
	 * @param username
	 * @param password
	 * @param passwordParams
	 * @return
	 */
	Map<ErrorCode, String> validateCreateUser(String username, String password,
			PasswordParameters passwordParams);
	
	/**
	 * validates reset password
	 * @param password
	 * @param passwordParams
	 * @return
	 */
	Map<ErrorCode, String> validateResetPassword(String password,
			PasswordParameters passwordParams);

}
