package gov.va.fnod.model;

import gov.va.fnod.security.authorization.AppRole;

/**
 * Enum for UserRole
 */
public enum UserRole implements AppRole<UserRole> {
	DEVELOPER,
	PSA, 
	OFFICE_SUPERVISOR, 
	ADMIN, 
	SYSTEM_ADMIN, 
	FNOD_DATA_LOADER,
	FLAG_APP_LOADER;
	
	/**
	 * get Enum from String
	 * 
	 * @param sourceReportTypeStr
	 * @return
	 */
	public static UserRole getEnum(String userRoleStr) {
		for (UserRole role : UserRole.values()) {
			if (role.name().equals(userRoleStr)) {
				return role;
			}
		}
		throw new IllegalArgumentException(
				"No Enum specified for userRole "
						+ userRoleStr);
	}
}
