package gov.va.fnod.model;



/**

 * Enum for SystemParameters

 */

public enum SystemParameters {

	USERNAME_MIN_LENGTH,

	USERNAME_MAX_LENGTH,

	LOGIN_RETRIES, 

	LOCKEDTIME_MIN, 

	PASSWORD_EXPIRY_DAYS,

	PASSWORD_HISTORY_COUNT,

	PASSWORD_WARNING_DAYS,

	PASSWORD_MIN_LENGTH, 

	PASSWORD_MAX_LENGTH, 

	PASSWORD_CHANGE_LIMIT_HRS;	



	

	/**

	 * get Enum from String

	 * 

	 * @param sourceReportTypeStr

	 * @return

	 */

	public static SystemParameters getEnum(String systemParameter) {

		for (SystemParameters type : SystemParameters.values()) {

			if (type.name().equals(systemParameter)) {

				return type;

			}

		}

		throw new IllegalArgumentException(

				"No Enum specified for systemParameter "

						+ systemParameter);

	}

}

