package gov.va.fnod.model;

import java.util.HashMap;
import java.util.Map;

public enum SourceCaseType {
	AMAS_FNOD(1), 
	AMAS_FNOD_SPOUSE(2), 
	BOSS_FNOD(3), 
	BOSS_FNOD_SPOUSE(4), 
	FLAG_APPLICATION(5), 
	INSURANCE_REPORT(6),
	ANC_FNOD(7),
	ANC_FNOD2(7),
	ANC_FNOD_SPOUSE(8),
	ANC_FNOD_SPOUSE2(8),
	PRUDENTIAL_INSURANCE(9);
	

	private final long sourceCaseTypeId;
	private final static Map<Long, SourceCaseType> caseIdMap = new HashMap<Long, SourceCaseType>(); 
  
	private SourceCaseType(long sourceCaseTypeId) {
		this.sourceCaseTypeId = sourceCaseTypeId;
	}
	
	static {
		for(SourceCaseType caseType: SourceCaseType.values()) {
			caseIdMap.put(caseType.getSourceCaseTypeId(),caseType);
		}
	}

	/**
	 * @return the sourceCaseTypeId
	 */
	public long getSourceCaseTypeId() {
		return sourceCaseTypeId;
	}
	
	public static SourceCaseType getSourceCaseType(long sourceCaseTypeId) {
		return caseIdMap.get(sourceCaseTypeId);
	}
}
